<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of FileIO
 *
 * @author erparom
 */
class FileIO {
  var $filePath;    // '../foo/bar.php'
  var $basename;    // 'bar.php'
  var $dirname;     // '../foo'
  var $filename;    // 'bar'
  var $extension;   // 'php'
  var $tempFile;    // 'bar.tmp'
  var $tempDir;     // '../cache/'
  var $backupFile;  // 'bar.bck'
  var $backupDir;   // '../cache/'
  var $file;
  var $temp;
  var $backup;

  public function  __construct($file="foo.bar", $mode="w", $tmp="/temp", $bck="/bck") {
    $this->filePath = $file;
    $f = pathinfo($file);
    $this->basename = $f['basename'];
    $this->dirname = $f['dirname'];
    $this->filename = $f['filename'];
    $this->extension = $f['extension'];
    $this->tempFile = $this->filename.".tmp";
    $this->tempDir = $tmp;
    $this->backupFile = $this->filename.".bck";
    $this->backupDir = $bck;
  }

  public function process($key, $new){
    //Realizar respaldo
    $b=$this->setbackupFile();
    if($b==false){
      echo "No se pudo realizar el respaldo de '$this->backupFile'.<br/>\n";
      return false;
    } else{
      echo "El respaldo  de '$this->backupFile' fue realizado con &eacute;xito.<br/>\n";
      //Hecho el respaldo, abrir el archivo original para editar linea
      $this->file = fopen($this->filePath, "r") or die ("No se pudo abrir el archivo $this->filePath.<br/>\n");
      $numLinea = $this->getLineNum($key, $this->file);
      $this->fileClose($this->file);
      if($this->addLine($key, $new, $this->filePath, $this->tempDir.$this->tempFile))
        return $b;
      else
        return false;
    }
  }

  public function addLine($key="ADD BELOW THIS", $new="ADD THIS", $file="FILETOADD", $tmp="TEMPFILE"){
    copy($file, $tmp) or exit("failed to copy $file");
    $fc = fopen ($file, "r");
    while (!feof ($fc)){
      $buffer = fgets($fc, 4096);
      $lines[] = $buffer;
    }
    fclose ($fc);
    $f=fopen($tmp,"w") or die("couldn't open $tmp");
    foreach($lines as $line){
      fwrite($f,$line);
      if (strstr($line,$key)){
        fwrite($f,$new."\n");
      }
    }
    fclose($f);
    copy($tmp, $file) or exit("failed to copy $tmp");
    unlink($tmp);
    return true;
  }

  public function fileClose($file){
    fclose($file);
  }

  private function getLineNum($key, $file){
    $i=0;
    while(!feof($file)){
      $i++;
      $buffer = fgets($file);
      if(strstr($buffer,$key)){
        return $i;
      }
    }
  }

  private function setbackupFile(){
    $file=$this->filePath;
    $bckfile=$this->backupDir.$this->backupFile.".".date("d-m-Y-H:m");
    $bck=copy($file, $bckfile);
    if($bck)
      return $bckfile;
    else
      return false;
  }

  private function setTempFile(){
    $this->temp = fopen($this->tempDir.$this->tempFile, "w") or die ("Could not open temp file<br/>\n");

  }

}
?>
