<script type="text/javascript">
function displayWindow(window){
  if(!window.isVisible()){
    window.show();
    window.center();
  } else {
    window.toFront();
    window.center();
  }
}
function displayComingSoon(){
  Ext.Msg.show({
    title:'<?=$s['msgCommingSoonTitle']?>',
    msg: '<?=$s['msgCommingSoon']?>',
    buttons: Ext.Msg.OK
  });
}
function insertData(form, urldest, grid, win){
  form.getForm().submit({
    clientValidation:true,
    waitMsg:'<?=$s['msgSavingData']?>',
    url:urldest,
    success:function(){
      Ext.Msg.alert('<?=$s['alertSavedData']?>', '<?=$s['alertSavedSuccess']?>');
      form.getForm().reset();
      grid.getStore().reload();
      win.getLayout().setActiveItem('grid');
    },
    failure:function(){Ext.Msg.alert('<?=$s['alertUnsavedData']?>', '<?=$s['alertSavedUnsuccessful']?>');}
  });
}
function updateData(form, urldest, grid, win){
  form.getForm().submit({
    clientValidation:true,
    waitMsg:'<?=$s['msgSavingChanges']?>',
    url:urldest,
    success:function(){
      Ext.Msg.alert('<?=$s['alertDataUpdated']?>', '<?=$s['alertDataUpdateSuccess']?>');
      form.getForm().reset();
      grid.getStore().reload();
      win.getLayout().setActiveItem(grid);
    },
    failure:function(){Ext.Msg.alert('<?=$s['alertDataNotUpdated']?>', '<?=$s['alertDataUpdateUnsuccessful']?>');}
  });
}
function deleteData(urldest, id){
  Ext.Ajax.request({
    waitMsg:'<?=$s['msgDeleteingData']?>',
    url: urldest+'&ID='+id,
    success: function(){
      Ext.MessageBox.alert('<?=$s['alertDataDeleted']?>', '<?=$s['alertDataDeleteSuccess']?>');
    },
    failure: function(response){Ext.MessageBox.alert('<?=$s['alertError']?>','<?=$s['alertDataDeleteFailure']?>'+response.responseText);}
  });
}

function checkSelected(grid){
  if(grid.selModel.getCount() == 1){
    return true;
  } else{Ext.MessageBox.alert('<?=$s['alertError']?>','<?=$s['alertSelectRecord']?>');return false;}
}

function createTableEditor(title, w, h, icon, gridStore, cols, formItems, taskNew, taskDelete, taskEdit, deleteHandler, newHandler, editHandler){
  var tb = new Ext.Toolbar({
    autoShow:true,
    items: [{
      text: '<?=$s['addRecord']?>', iconCls: 'new',
      handler: newHandler
    }, '-',{
      text: '<?=$s['editRecord']?>', iconCls: 'edit',
      handler: editHandler
    }, '-',{
      text: '<?=$s['deleteRecord']?>', iconCls:'delete',
      handler: deleteHandler
    }]
  });
  var formNew = Ext.form.FormPanel({
    title:'<?=$s['newTipeOf']?>'+title,
    iconCls:'add',
    autoWidth:true,
    layout:'form',
    hideLabel:true,
    hideLabels:true,
    labelWidth:0,
    bodyStyle:'padding:10px 10px 10px 10px',
    items:formItems,
    buttons:[
      {text:'<?=$s['btnSave']?>', iconCls:'save', handler:function(){insertData(formNew, taskNew, grid, win);}},
      {text:'<?=$s['btnCancel']?>', iconCls:'cancel', handler: function(){formNew.getForm().reset();win.getLayout().setActiveItem(grid);}}
    ]
  });
  var formEdit = Ext.form.FormPanel({
    title:'<?=$s['editSomething']?>'+title,
    iconCls:'edit',
    autoWidth:true,
    layout:'form',
    bodyStyle:'padding:10px 10px 10px 10px',
    items:formItems,
    buttons:[
      {text:'<?=$s['btnSave']?>', iconCls:'save', handler: function(){updateData(formEdit, taskEdit, grid, win);}},
      {text:'<?=$s['btnCancel']?>', iconCls:'cancel', handler: function(){win.getLayout().setActiveItem(grid);}}
    ]
  });
  var grid = new Ext.grid.GridPanel({
    title:'<?=$s['seeSomething']?>'+title,
    iconCls:'list',
    autoshow:true,
    selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),
    tbar: tb,
    bbar: new Ext.PagingToolbar({pageSize:15, store:gridStore, displayInfo: true}),
    store:gridStore,
    columns:cols
  });
  var win = new Ext.Window({
    title:'<?=$s['panelOfSomething']?>'+title,
    closable:true,
    closeAction:'hide',
    width:w,
    height:h,
    maximizable:true,
    plain:true,
    layout: 'card',
    activeItem:0,
    layoutConfig:{ animate:true },
    iconCls: icon,
    buttons:[{text:'<?=$s['btnClose']?>', iconCls:'close', handler: function(){win.hide();}}],
    items:[grid, formNew, formEdit]
  });
  win.show();
}
function reloadLang(lang){
  document.location="http://autocondat.erparom.com/index.php?lang="+lang;
}
function getLogo(){
  Ext.Ajax.request({
    waitMsg:'<?=$s['waitMsg']?>',
    url: 'includes/mainApp.php?task=GETLOGO',
    success: function(response){
      document.siteImageLogo.src = "images/"+response.responseText;
    },
    failure: function(response){Ext.MessageBox.alert('<?=$s['alertError']?>','<?=$s['alertFailure']?>'+response.responseText);}
  });
}
</script>
