<script type="text/javascript">
var appsPanel = new Ext.FormPanel({
  formId:'appsForm',
  autoWidth:true,
  autoShow:true,
  autoScroll:true,
  hideLabel:true,
  title:'<?=$s['appsTitle']?>',
  iconCls:'apps',
  layout:'form',
  bodyStyle:'padding:2px 2px 2px 2px',
  listeners:{
    scope:this,
    'afterrender': function(frm){
      Ext.Ajax.request({
        waitMsg:'<?=$s['waitMsg']?>',
        url:'includes/apps.php',
        success: function(response){
          var result = Ext.util.JSON.decode(response.responseText);
          Ext.each(result, function(item) {
            idApp = parseInt(item.idApp);
            app = item.app;
            icon = item.icon;
            url = 'http://'+item.url;
            desc = item.desc;
            frm.add({
              xtype:'button',
              iconCls:icon,
              iconAlign:'left',
              scale:'large',
              text:app,
              tooltip:desc,
              width:'100%',
              hideLabel:true,
              fieldLabel:url,
              handler:function(){
                window.open(this.fieldLabel, '_blank');
              }
            });
          });
          appsPanel.doLayout();
        }, failure: function(response){Ext.MessageBox.alert('<?=$s['alertError']?>','<?=$s['alertFailure']?>'+response.responseText);}
      });
    }
  }
});
</script>