<?php


class systemConfig {

    private $username="root";
    private $password="root";
    private $database="db_agenda";
    private $pathServer= "mcgcitasenlinea-code/AgendaElectronica";
    private $domain="http://localhost";
    private $servername;
    private $templateStr;
    private $installerphp="install.php";
    private $ConfigFilePath=null;
    private $smtphost="";
    private $smtpport=0;
    private $smtpuser="";
    private $smtppassword="";
    private $smtpemail="";
    

    public function __construct(string $username,string $password,string $database,string $servermysql){
        $this->setDBinfo($username,$password,$database,$servermysql);
        $this->setPathServer();
        $this->setDomain();
    }

    public function setDBinfo(string $username,string $password,string $database,string $servermysql){
        if(is_null($username) && is_null($password) && is_null($database) && is_null($servermysql)){
            throw new Exception("database values NullReferenceException");
        }

        $this->username=$username;
        $this->password=$password;
        $this->database=$database;
        $this->servername=$servermysql;
        $this->templateStr= new ListArray();
    }

    public function setSMTPInfo(string $host, int $port, string $user, string $pass, string $emailFrom){
        $this->smtphost=$host;
        $this->smtpport=$port;
        $this->smtpuser=$user;
        $this->smtppassword=$pass;
        $this->smtpemail=$emailFrom;
    }

    public function setPathServer(){
        $root=str_replace("/installer/$this->installerphp","",$_SERVER['PHP_SELF']);
        $root=substr($root,1,strlen($root));
        $this->pathServer=$root;
        return $root;
    }

    public function setDomain(){
        $this->domain="http://".$_SERVER['HTTP_HOST'];
        return "http://".$_SERVER['HTTP_HOST'];
    }

    public function loadTemplate(){
        $myfile = fopen("Config.txt", "r",true) or die("Unable to open file!");
        while(!feof($myfile)){
            $this->templateStr->addItem(fgets($myfile));
        }
        fclose($myfile);
        return $this->templateStr;
    }

    public function SetConfigurationVars(){
        $index=0;
        foreach($this->templateStr->array as $line){
            $foundUserName=strpos($line,"@username");
            if($foundUserName>-1)
                $this->templateStr->array[$index]=str_replace("@username",$this->username,$line);
            
            $foundPassword=strpos($line,"@password");
            if($foundPassword>-1)
                $this->templateStr->array[$index]=str_replace("@password",$this->password,$line);
            
            $foundDatabse=strpos($line,"@database");
            if($foundDatabse>-1)
                $this->templateStr->array[$index]=str_replace("@database",$this->database,$line);
            
            $foundserver=strpos($line,"@servername");
            if($foundserver>-1)
                $this->templateStr->array[$index]=str_replace("@servername",$this->servername,$line);

            $foundpathserver=strpos($line,"@pathserver");
            if($foundpathserver>-1)
                $this->templateStr->array[$index]=str_replace("@pathserver",$this->pathServer,$line);

            $foundDomain=strpos($line,"@domain");
            if($foundDomain>-1)
                $this->templateStr->array[$index]=str_replace("@domain",$this->domain,$line);

            $foundSmtpHost=strpos($line,"@smtpHost");
            if($foundSmtpHost>-1)
                $this->templateStr->array[$index]=str_replace("@smtpHost",$this->smtphost,$line);

            $foundSmtpPort=strpos($line,"@smtpPort");
            if($foundSmtpPort>-1)
                    $this->templateStr->array[$index]=str_replace("@smtpPort",$this->smtpport,$line);
            
            $foundSmtpUser=strpos($line,"@smtpUserName");
                if($foundSmtpUser>-1)
                    $this->templateStr->array[$index]=str_replace("@smtpUserName",$this->smtpuser,$line);


            $foundSmtpPass = strpos($line, "@smtpPassword");
            if ($foundSmtpPass > -1)
                $this->templateStr->array[$index] = str_replace("@smtpPassword", $this->smtppassword, $line);


            $foundSmtpFrom = strpos($line, "@smtpFrom");
            if ($foundSmtpFrom > -1)
                $this->templateStr->array[$index] = str_replace("@smtpFrom", $this->smtpemail, $line);

            $index++;
        }
    } 

    public function CreateConfigFile(){
        if($this->ExistConfigFile()){
           //throw new Exception("Config.php file exist");
           $this->renameConfigFile();
        }

        $configfile=$_SERVER["DOCUMENT_ROOT"]."/".$this->pathServer."/Config.php";      
        $myfile = fopen($configfile, "w") or die("Unable to open file!");
        foreach($this->templateStr->array as $line){
            fwrite($myfile, $line);
        }
        fclose($myfile);
    }

    public function ExistConfigFile(){
        $pathsplit= explode("/",$_SERVER['PHP_SELF']);
        if(count($pathsplit)>2){
            $root=$_SERVER["DOCUMENT_ROOT"]."/".$pathsplit[1];
        }else{
            $root=$_SERVER["DOCUMENT_ROOT"];
        }
        $this->SearchConfig($root);
        return is_null($this->ConfigFilePath) ? false : true ;
    }

    public function renameConfigFile(){
        rename($this->ConfigFilePath,  $this->ConfigFilePath.".old");
    }

    protected function SearchConfig($root){
        $FolderScanned=scandir($root);
        foreach ($FolderScanned as $key => $Value) {
            if (!in_array($Value,array(".",".."))){
                if(is_dir($root."/".$Value)){
                    $this->SearchConfig($root."/".$Value);
                }
                if($Value=="Config.php"){
                    $this->ConfigFilePath=$root."/".$Value;
                }
            }
        }
    }

}



?>