<?php

class CamposFormaTableConfig implements iobjconfig{
    
    private $ObjMapper;

    public function __construct(){
        $this->ObjMapper= new CamposFormaObjMap();
    }

    public function setTableConfiguration(){
        $this->ObjMapper->setTableConfig();
        $this->Field("idcampoforma")->setPrimaryKey(true)->setAutoincrement(true)->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("nombre")->setVarcharSize(255)->setFieldType(EPHPType::STRING_TYPE);
        $this->Field("activo")->setFieldType(EPHPType::BOOLEAN_TYPE);
        $this->Field("valorpordefecto")->setFieldType(EPHPType::STRING_TYPE);
        $this->Field("idforma")->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("idtipocampo")->setFieldType(EPHPType::INTEGER_TYPE);
    }

    public function Field(string $fieldname){
        return $this->ObjMapper->getObjectTableConfig()->Field($fieldname);
    }

    public function getSQLStr(){
        $this->setTableConfiguration();
        return $this->ObjMapper->getObjectTableConfig()->toString();
    }

    public function addField(string $nombre,$objecType){
        return $this->ObjMapper->getObjectTableConfig()->addField($nombre,$objecType);
    }
}

?>