<?php

class CitaTableConfig implements iobjconfig{
    private $ObjMapper;

    public function __construct(){
        $this->ObjMapper= new CitasObjMap();
    }

    public function setTableConfiguration(){
        $this->ObjMapper->setTableConfig();
        $this->Field("idcita")->setPrimaryKey(true)->setAutoincrement(true)->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("dia")->setFieldType(EPHPType::STRING_TYPE)->setVarcharSize(2);
        $this->Field("mes")->setFieldType(EPHPType::STRING_TYPE)->setVarcharSize(2);
        $this->Field("anio")->setFieldType(EPHPType::STRING_TYPE)->setVarcharSize(4);
        $this->addField("hr_inicio",null);
        $this->Field("hr_inicio")->setFieldType(EPHPType::STRING_TYPE)->setVarcharSize(8);
        $this->addField("hr_fin",null);
        $this->Field("hr_fin")->setFieldType(EPHPType::STRING_TYPE)->setVarcharSize(8);
        $this->Field("iduser")->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("idestatus")->setFieldType(EPHPType::STRING_TYPE)->setVarcharSize(100);
        $this->Field("editmode")->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("nota")->setFieldType(EPHPType::LONGTEXT_TYPE);
    }

    public function Field(string $fieldname){
        return $this->ObjMapper->getObjectTableConfig()->Field($fieldname);
    }

    public function getSQLStr(){
        $this->setTableConfiguration();
        return $this->ObjMapper->getObjectTableConfig()->toString();
    }

    public function addField(string $nombre,$objecType){
        return $this->ObjMapper->getObjectTableConfig()->addField($nombre,$objecType);
    }

}
?>