<?php

class EstatusCitaTableConfig implements iobjconfig{
    private $ObjMapper;

    public function __construct(){
        $this->ObjMapper= new EstatusCitaObjMap();
    }

    public function setTableConfiguration(){
        $this->ObjMapper->setTableConfig();
        $this->Field("idestatus")->setPrimaryKey(true)->setAutoincrement(true);
        $this->Field("estado")->setFieldType(EPHPType::STRING_TYPE)->setVarcharSize(55);
        $this->Field("activo")->setFieldType(EPHPType::INTEGER_TYPE);
    }

    public function Field(string $fieldname){
        return $this->ObjMapper->getObjectTableConfig()->Field($fieldname);
    }

    public function getSQLStr(){
        $this->setTableConfiguration();
        return $this->ObjMapper->getObjectTableConfig()->toString();
    }

    public function addField(string $nombre,$objecType){
        return $this->ObjMapper->getObjectTableConfig()->addField($nombre,$objecType);
    }
}
?>