<?php

class FormasTableConfig implements iobjconfig{
    private $ObjMapper;

    public function __construct(){
        $this->ObjMapper= new FormasObjMap();
    }

    public function setTableConfiguration(){
        $this->ObjMapper->setTableConfig();
        $this->Field("idforma")->setPrimaryKey(true)->setAutoincrement(true)->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("descripcion")->setFieldType(EPHPType::STRING_TYPE);
        $this->Field("visible")->setFieldType(EPHPType::BOOLEAN_TYPE);
        $this->Field("activo")->setFieldType(EPHPType::BOOLEAN_TYPE);
        $this->Field("seleccion")->setFieldType(EPHPType::BOOLEAN_TYPE);
    }

    public function Field(string $fieldname){
        return $this->ObjMapper->getObjectTableConfig()->Field($fieldname);
    }

    public function getSQLStr(){
        $this->setTableConfiguration();
        return $this->ObjMapper->getObjectTableConfig()->toString();
    }

    public function addField(string $nombre,$objecType){
        return $this->ObjMapper->getObjectTableConfig()->addField($nombre,$objecType);
    }
}

?>