<?php

class MenuTableConfig implements iobjconfig{
    private $ObjMapper;

    public function __construct(){
        $this->ObjMapper= new MenuObjMap();
    }

    public function setTableConfiguration(){
        $this->ObjMapper->setTableConfig();
        $this->Field("idmenu")->setPrimaryKey(true)->setAutoincrement(true)->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("etiqueta")->setFieldType(EPHPType::STRING_TYPE);
        $this->Field("path")->setFieldType(EPHPType::STRING_TYPE);
        $this->Field("activo")->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("hasmenus")->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("accion")->setFieldType(EPHPType::STRING_TYPE);
        $this->Field("idmodulo")->setFieldType(EPHPType::INTEGER_TYPE);
    }

    public function Field(string $fieldname){
        return $this->ObjMapper->getObjectTableConfig()->Field($fieldname);
    }

    public function getSQLStr(){
        $this->setTableConfiguration();
        return $this->ObjMapper->getObjectTableConfig()->toString();
    }

    public function addField(string $nombre,$objecType){
        return $this->ObjMapper->getObjectTableConfig()->addField($nombre,$objecType);
    }
}
?>