<?php

class TipoCampoTableConfig implements iobjconfig{
    private $ObjMapper;

    public function __construct(){
        $this->ObjMapper= new TipoCampoObjMap();
    }

    public function setTableConfiguration(){
        $this->ObjMapper->setTableConfig();
        $this->Field("idtiposcampo")->setPrimaryKey(true)->setAutoincrement(true)->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("descripcion")->setFieldType(EPHPType::STRING_TYPE)->setVarcharSize(55);
        $this->Field("tipo")->setFieldType(EPHPType::STRING_TYPE)->setVarcharSize(55);
        $this->Field("activo")->setFieldType(EPHPType::STRING_TYPE)->setVarcharSize(55);
        $this->Field("htmlcode")->setFieldType(EPHPType::LONGTEXT_TYPE);
        $this->Field("selmultiple")->setFieldType(EPHPType::BOOLEAN_TYPE);
    }

    public function Field(string $fieldname){
        return $this->ObjMapper->getObjectTableConfig()->Field($fieldname);
    }

    public function getSQLStr(){
        $this->setTableConfiguration();
        return $this->ObjMapper->getObjectTableConfig()->toString();
    }

    public function addField(string $nombre,$objecType){
        return $this->ObjMapper->getObjectTableConfig()->addField($nombre,$objecType);
    }
}


?>