<?php

class UserTableConfig implements iobjconfig{
    private $ObjMapper;

    public function __construct(){
        $this->ObjMapper= new UserObjMap();
    }

    public function setTableConfiguration(){
        $this->ObjMapper->setTableConfig();
        $this->Field("iduser")->setPrimaryKey(true)->setAutoincrement(true)->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("email")->setFieldType(EPHPType::STRING_TYPE);
        $this->Field("password")->setFieldType(EPHPType::STRING_TYPE);
        $this->Field("nombre")->setFieldType(EPHPType::STRING_TYPE);
        $this->Field("apellidos")->setFieldType(EPHPType::STRING_TYPE);
        $this->Field("active")->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("idprofile")->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("activationtoken")->setFieldType(EPHPType::STRING_TYPE)->setVarcharSize(100);
    
    }

    public function Field(string $fieldname){
        return $this->ObjMapper->getObjectTableConfig()->Field($fieldname);
    }

    public function getSQLStr(){
        $this->setTableConfiguration();
        return $this->ObjMapper->getObjectTableConfig()->toString();
    }

    public function addField(string $nombre,$objecType){
        return $this->ObjMapper->getObjectTableConfig()->addField($nombre,$objecType);
    }
}


?>