<?php

class ValorFormaTableConfig implements iobjconfig{
    private $ObjMapper;

    public function __construct(){
        $this->ObjMapper= new ValorCampoFormaObjMap();
    }

    public function setTableConfiguration(){
        $this->ObjMapper->setTableConfig();
        $this->Field("idformavalores")->setPrimaryKey(true)->setAutoincrement(true)->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("idforma")->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("idcampoforma")->setFieldType(EPHPType::INTEGER_TYPE);
        $this->Field("valor")->setFieldType(EPHPType::LONGTEXT_TYPE);
        $this->Field("idcita")->setFieldType(EPHPType::INTEGER_TYPE);
    }

    public function Field(string $fieldname){
        return $this->ObjMapper->getObjectTableConfig()->Field($fieldname);
    }

    public function getSQLStr(){
        $this->setTableConfiguration();
        return $this->ObjMapper->getObjectTableConfig()->toString();
    }

    public function addField(string $nombre,$objecType){
        return $this->ObjMapper->getObjectTableConfig()->addField($nombre,$objecType);
    }
}

?>