<?php

class AgendaDefaults implements iDefaultData {

    protected $mysql;
    protected $ListArrayInstructions;

    public function __construct(){
        $this->mysql= new MysqlConnector();
        $this->ListArrayInstructions= new ArrayList();
        $this->defaultData();
    }

    public function buildInstruction(string $instruction){
        $this->ListArrayInstructions->addItem($instruction);
    }

    public function defaultData(){
        $this->buildInstruction("INSERT INTO `t_regla_diasdisp` (`dia`, `activo`) VALUES
                                                ('lunes', 1),
                                                ('martes', 1),
                                                ('miercoles', 1),
                                                ('jueves', 1),
                                                ('viernes', 1);");
        $this->buildInstruction("INSERT INTO `t_regla_general` (`variable`, `valor`) VALUES
                                    ('TiempoEstimadoCita', '30'),
                                    ('TiempoEntreCita', '10');");
        $this->buildInstruction("INSERT INTO `t_regla_horarios` (`hr_inicio`, `hr_fin`) VALUES
                                    ('08:00', '12:30'),
                                    ('14:00', '16:00');");
    }

    public function getSQLStr(){
        $str="";
        foreach($this->ListArrayInstructions->array as $values){
            $str=$str . $values ." "; 
        }
        return $str;
    }

    public function getInstructionsListArray(){
        return $this->ListArrayInstructions;
    }

    public function loadDefaults(){
        try {
            $this->mysql->OpenConnection();
            foreach($this->ListArrayInstructions->array as $instructions){
                $this->mysql->conn->query($instructions);
            }
            $this->mysql->CloseDataBase();
        } catch (\Throwable $th) {
            throw $th;
        }
    }

}

?>