<?php

class CitasEstatusDefaults implements iDefaultData {

    protected $mysql;
    protected $ListArrayInstructions;

    public function __construct(){
        $this->mysql= new MysqlConnector();
        $this->ListArrayInstructions= new ArrayList();
        $this->defaultData();
    }

    public function buildInstruction(string $instruction){
        $this->ListArrayInstructions->addItem($instruction);
    }

    public function defaultData(){
        $this->buildInstruction("INSERT INTO `t_citas_estatus` (`estado`, `Activo`) VALUES
                                    ('Atendida', 1),
                                    ('Cancelada', 1),
                                    ('No Atendida', 1);");
    }

    public function getSQLStr(){
        $str="";
        foreach($this->ListArrayInstructions->array as $values){
            $str=$str . $values ." "; 
        }
        return $str;
    }

    public function getInstructionsListArray(){
        return $this->ListArrayInstructions;
    }

    public function loadDefaults(){
        try {
            $this->mysql->OpenConnection();
            foreach($this->ListArrayInstructions->array as $instructions){
                $this->mysql->conn->query($instructions);
            }
            $this->mysql->CloseDataBase();
        } catch (\Throwable $th) {
            throw $th;
        }
    }


}

?>