<?php

class FormasTipoCamposDefaults implements iDefaultData {

    protected $mysql;
    protected $ListArrayInstructions;

    public function __construct(){
        $this->mysql= new MysqlConnector();
        $this->ListArrayInstructions= new ArrayList();
        $this->defaultData();
    }

    public function buildInstruction(string $instruction){
        $this->ListArrayInstructions->addItem($instruction);
    }

    public function defaultData(){
        $this->buildInstruction("INSERT INTO `t_campos_tipos` (`descripcion`, `tipo`, `activo`, `htmlcode`, `selmultiple`) VALUES
        ('Etiqueta simple en formulario', ' Etiqueta', '1', 'PHA+PGxhYmVsIG5hbWU9Jm5hbWU+JnZhbHVlPC9sYWJlbD48cD4=', 0),
        ('Muestra un Texto en el formulario', 'Texto Simple', '1', 'PHA+JnZhbHVlPHA+', 0),
        ('Muestra una area de Texto ', 'Area Texto', '1', 'Jm5hbWUNCjxicj4NCjx0ZXh0YXJlYSBuYW1lPSImbmFtZV8maWQiIHZhbHVlPSImdmFsdWUiPjwvdGV4dGFyZWE+', 0),
        ('Caja de Texto', 'Caja de Texto', '1', 'PGJyLz4mbmFtZTogPGlucHV0IG5hbWU9IiZuYW1lXyZpZCIgdmFsdWU9IiZ2YWx1ZSIgc3R5bGU9ImZvbnQtc2l6ZTogbGFyZ2UiIC8+', 0),
        ('Titulo usando html tag h1', 'Encabezado h1', '1', 'PGgyPiZ2YWx1ZTwvaDI+', 0),
        ('Seleccion multiple caja de opciones simple', 'Seleccion multiple combobox', '1', 'PHA+Jm5hbWU8c2VsZWN0IG5hbWU9IiZuYW1lXyZpZCI+Jmxpc3Q8b3B0aW9uIHZhbHVlPSImdmFsdWUiPiZ2YWx1ZTwvb3B0aW9uPiZsaXN0PC9zZWxlY3Q+PHA+', 1),
        ('Seleccion multiple boton radial ', 'Seleccion multiple boton radial', '1', 'PHA+Jmxpc3Q8aW5wdXQgdHlwZT0icmFkaW8iIG5hbWU9IiZuYW1lXyZpZCIgdmFsdWU9IiZ2YWx1ZSIgLz7CoCAmdmFsdWUgJmxpc3Q8L3A+', 1),
        ('Seleccion Multiple Caja de Check', 'Caja Check', '1', 'PGgyPlNlbGVjaW9uZSBsYSBvcGNpb248L2gyPg0KJmxpc3Q8aW5wdXQgdHlwZT0iY2hlY2tib3giIG5hbWU9IiZuYW1lXyZpZCIgdmFsdWU9IiZ2YWx1ZSI+wqAmdmFsdWUgJmxpc3Q=', 1);");
    }

    public function getSQLStr(){
        $str="";
        foreach($this->ListArrayInstructions->array as $values){
            $str=$str . $values ." "; 
        }
        return $str;
    }

    public function getInstructionsListArray(){
        return $this->ListArrayInstructions;
    }

    public function loadDefaults(){
        try {
            $this->mysql->OpenConnection();
            foreach($this->ListArrayInstructions->array as $instructions){
                $this->mysql->conn->query($instructions);
            }
            $this->mysql->CloseDataBase();
        } catch (\Throwable $th) {
            throw $th;
        }
    }


}

?>