<?php

class MenusDefaults implements iDefaultData {

    protected $mysql;
    protected $ListArrayInstructions;

    public function __construct(){
        $this->mysql= new MysqlConnector();
        $this->ListArrayInstructions= new ArrayList();
        $this->defaultData();
    }

    public function buildInstruction(string $instruction){
        $this->ListArrayInstructions->addItem($instruction);
    }

    public function defaultData(){
        $this->buildInstruction("INSERT INTO `t_menus` (`etiqueta`, `activo`, `path`, `hasmenus`, `accion`, `idModulo`) VALUES
                                    ('Administraci&oacuten de Modulos', 1, '/modules/SysManager/ModuleManager.php', 0, '', 2),
                                    ('Administraci&oacuten de Menus', 1, '/modules/SysManager/MenuManager.php', 0, '', 2),
                                    ('Ver Citas Programadas', 1, '/modules/CitasManager/CitasManager.php', 0, '', 3),
                                    ('Configurar Horarios', 1, '/modules/ConfiguracionAgenda/AgendaConfManager.php', 0, '', 4),
                                    ('Roles y Permisos', 1, '/modules/AccessManagement/AccessManagement.php', 0, '', 2),
                                    ('Usuarios Registrados', 1, '/modules/UserManager/UserManager.php', 0, '', 2),
                                    ('Administraci&oacuten de Formas', 1, '/modules/FormsManager/FormsManager.php', 0, '', 2);");

        $this->buildInstruction("INSERT INTO `t_profile_menu` (`idprofile`, `idMenu`) VALUES
                                    (3, 3),
                                    (2, 1),
                                    (2, 2),
                                    (2, 5),
                                    (2, 6),
                                    (2, 3),
                                    (2, 4);");
    }

    public function getSQLStr(){
        $str="";
        foreach($this->ListArrayInstructions->array as $values){
            $str=$str . $values ." "; 
        }
        return $str;
    }

    public function getInstructionsListArray(){
        return $this->ListArrayInstructions;
    }

    public function loadDefaults(){
        try {
            $this->mysql->OpenConnection();
            foreach($this->ListArrayInstructions->array as $instructions){
                $this->mysql->conn->query($instructions);
            }
            $this->mysql->CloseDataBase();
        } catch (\Throwable $th) {
            throw $th;
        }
    }


}

?>