<?php

class ModulesDefaults implements iDefaultData {

    protected $mysql;
    protected $ListArrayInstructions;

    public function __construct(){
        $this->mysql= new MysqlConnector();
        $this->ListArrayInstructions= new ArrayList();
        $this->defaultData();
    }

    public function buildInstruction(string $instruction){
        $this->ListArrayInstructions->addItem($instruction);
    }

    public function defaultData(){
        $this->buildInstruction("INSERT INTO `t_modulos` (`etiqueta`, `activo`, `path`, `hasmenus`, `accion`) VALUES
                                    ('Agenda Tu Cita', 1, '/modules/Agenda/ViewAgenda.php', 0, ''),
                                    ('Configuracion de Sistema', 1, '#', 0, ''),
                                    ('Administraci&oacuten Agenda', 1, '#', 0, ''),
                                    ('Configuraci&oacuten Agenda', 1, '#', 0, '');");
        $this->buildInstruction("INSERT INTO `t_profile_module` (`idprofile`, `idmodulo`) VALUES
        (1, 1),
        (3, 3),
        (2, 1),
        (2, 2),
        (2, 3),
        (2, 4);");
    }

    public function getSQLStr(){
        $str="";
        foreach($this->ListArrayInstructions->array as $values){
            $str=$str . $values ." "; 
        }
        return $str;
    }

    public function getInstructionsListArray(){
        return $this->ListArrayInstructions;
    }

    public function loadDefaults(){
        try {
            $this->mysql->OpenConnection();
            foreach($this->ListArrayInstructions->array as $instructions){
                $this->mysql->conn->query($instructions);
            }
            $this->mysql->CloseDataBase();
        } catch (\Throwable $th) {
            throw $th;
        }
    }

}

?>