<?php

class UsersDefaults implements iDefaultData {

    protected $mysql;
    protected $ListArrayInstructions;

    public function __construct(){
        $this->mysql= new MysqlConnector();
        $this->ListArrayInstructions= new ArrayList();
        $this->defaultData();
    }

    public function buildInstruction(string $instruction){
        $this->ListArrayInstructions->addItem($instruction);
    }

    public function defaultData(){
        $this->buildInstruction("insert into t_users (email,password,nombre,apellidos,active,idprofile) 
                                values ('admin@server.com', '81dc9bdb52d04dc20036dbd8313ed055', 'Administrador', 'del Sistema', 1, 2),
                                ('adminagenda@server.com', '81dc9bdb52d04dc20036dbd8313ed055', 'Administrador', 'de Agenda', 1, 3);");
    }

    public function getSQLStr(){
        $str="";
        foreach($this->ListArrayInstructions->array as $values){
            $str=$str . $values ." "; 
        }
        return $str;
    }

    public function getInstructionsListArray(){
        return $this->ListArrayInstructions;
    }

    public function loadDefaults(){
        try {
            $this->mysql->OpenConnection();
            foreach($this->ListArrayInstructions->array as $instructions){
                $this->mysql->conn->query($instructions);
            }
            $this->mysql->CloseDataBase();
        } catch (\Throwable $th) {
            throw $th;
        }
    }

}

?>