-- /** Copyright 2019
-- *
-- * Author: Ismael PONCE GORDILLO
-- *
-- * Licensed under the EUPL, Version 1.2 or – as soon they will be
-- * approved by the European Commission – subsequent versions of the
-- * EUPL (the "Licence"); you may not use this work except in
-- * compliance with the Licence.
-- * You may obtain a copy of the Licence at:
-- *
-- * https://joinup.ec.europa.eu/software/page/eupl/licence-eupl
-- *
-- * Unless required by applicable law or agreed to in writing,
-- * software distributed under the Licence is distributed on an "AS
-- * IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
-- * express or implied.
-- * See the Licence for the specific language governing permissions
-- * and limitations under the Licence.
-- */


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `accesos`
--

DROP TABLE IF EXISTS `accesos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accesos` (
  `Alumno` int(11) NOT NULL DEFAULT '0',
  `IP` char(15) NOT NULL,
  `instante` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Encuesta` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `asignaturas`
--

DROP TABLE IF EXISTS `asignaturas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asignaturas` (
  `Código` int(11) NOT NULL AUTO_INCREMENT,
  `Curso` int(11) NOT NULL,
  `Asignatura` varchar(255) NOT NULL,
  `Matrícula` enum('Si','No') NOT NULL DEFAULT 'No',
  PRIMARY KEY (`Código`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cursa`
--

DROP TABLE IF EXISTS `cursa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursa` (
  `Año` char(9) NOT NULL,
  `Alumno` int(11) NOT NULL,
  `Asignatura` int(11) NOT NULL,
  PRIMARY KEY (`Año`,`Alumno`,`Asignatura`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `curso`
--

DROP TABLE IF EXISTS `curso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `curso` (
  `Código` int(11) NOT NULL AUTO_INCREMENT,
  `Enseñanza` varchar(255) NOT NULL,
  `Nivel` int(11) NOT NULL,
  PRIMARY KEY (`Código`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `datospersonales`
--

DROP TABLE IF EXISTS `datospersonales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `datospersonales` (
  `Código` int(11) NOT NULL AUTO_INCREMENT,
  `Clave` varchar(32) NOT NULL,
  `Apellidos` varchar(100) NOT NULL DEFAULT '',
  `Nombre` varchar(50) NOT NULL DEFAULT '',
  `DNI` int(8) NOT NULL DEFAULT '0',
  `Apodo` varchar(64) DEFAULT NULL,
  `Nacimiento` date NOT NULL,
  `Dirección` varchar(100) DEFAULT NULL,
  `Población` varchar(50) DEFAULT NULL,
  `Postal` varchar(6) DEFAULT NULL,
  `Tutor` varchar(150) DEFAULT NULL,
  `Teléfono` varchar(9) DEFAULT NULL,
  `Móvil` varchar(9) DEFAULT NULL,
  `Email` varchar(150) DEFAULT NULL,
  `Coche` enum('No','Si') NOT NULL DEFAULT 'No',
  `Ordenador` enum('No','Si') NOT NULL DEFAULT 'No',
  `Internet` enum('No','Si') NOT NULL DEFAULT 'No',
  `Estudios` text,
  `Cursos` text,
  `Trabajos` text,
  PRIMARY KEY (`Código`),
  UNIQUE KEY `DNI` (`DNI`)
) ENGINE=MyISAM AUTO_INCREMENT=140 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `encuestas`
--

DROP TABLE IF EXISTS `encuestas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `encuestas` (
  `Código` int(11) NOT NULL AUTO_INCREMENT,
  `Asignatura` int(11) NOT NULL DEFAULT '1',
  `Título` varchar(255) DEFAULT NULL,
  `Fecha` date NOT NULL DEFAULT '0000-00-00',
  `Activa` enum('No','Si') NOT NULL DEFAULT 'No',
  PRIMARY KEY (`Código`)
) ENGINE=MyISAM AUTO_INCREMENT=82 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `opciones`
--

DROP TABLE IF EXISTS `opciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opciones` (
  `Código` int(11) NOT NULL AUTO_INCREMENT,
  `Encuesta` int(11) NOT NULL DEFAULT '0',
  `Pregunta` int(11) NOT NULL DEFAULT '0',
  `Enunciado` text,
  PRIMARY KEY (`Código`)
) ENGINE=MyISAM AUTO_INCREMENT=3536 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `preguntas`
--

DROP TABLE IF EXISTS `preguntas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `preguntas` (
  `Código` int(11) NOT NULL AUTO_INCREMENT,
  `Encuesta` int(11) NOT NULL DEFAULT '0',
  `Enunciado` text NOT NULL,
  `Test` enum('Test','Texto') NOT NULL DEFAULT 'Test',
  `correcta` int(11) NOT NULL DEFAULT '0',
  `TextoMax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`Código`)
) ENGINE=MyISAM AUTO_INCREMENT=987 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `respuestas`
--

DROP TABLE IF EXISTS `respuestas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `respuestas` (
  `Alumno` int(11) NOT NULL DEFAULT '0',
  `Encuesta` int(11) NOT NULL DEFAULT '0',
  `Pregunta` int(11) NOT NULL DEFAULT '0',
  `Test` int(1) NOT NULL DEFAULT '0',
  `Texto` text,
  `TextoPuntos` decimal(2,1) NOT NULL,
  PRIMARY KEY (`Alumno`,`Encuesta`,`Pregunta`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2011-12-15  9:01:45
