<?php
/** Copyright 2019
*
* Author: Ismael PONCE GORDILLO
*
* Licensed under the EUPL, Version 1.2 or – as soon they will be
* approved by the European Commission – subsequent versions of the
* EUPL (the "Licence"); you may not use this work except in
* compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* https://joinup.ec.europa.eu/software/page/eupl/licence-eupl
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the Licence is distributed on an "AS
* IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied.
* See the Licence for the specific language governing permissions
* and limitations under the Licence.
*/

	function fecha_mysql($cadena) {
		if($cadena != "") {
			$contador=0;
			$parte=strtok(trim($cadena), "-");
			while($parte) {
				$contador++;
				$valor[$contador]=$parte;
				$parte=strtok("-");
			}
			$date = date("Y-m-d", mktime(0,0,0,$valor[2],$valor[1],$valor[3])); 
		} else {
			$date = "1970-01-01";
		}
		return $date;
	}
	function fecha_europeo($cadena) {
		if($cadena != "") {
			$contador=0;
			$parte=strtok(trim($cadena), "-");
			while($parte) {
				$contador++;
				$valor[$contador]=$parte;
				$parte=strtok("-");
			}
			$date = date("d-m-Y", mktime(0,0,0,$valor[2],$valor[3],$valor[1])); 
		} else {
			$date = "01-01-1970";
		}
		return $date;
	}
	function fecha_europea_valida($cadena) {
		if($cadena != "") {
			$contador=0;
			$parte=strtok(trim($cadena), "-");
			while($parte) {
				$contador++;
				$valor[$contador]=$parte;
				$parte=strtok("-");
			}
			if (isset($valor[1]) && isset($valor[2]) && isset($valor[3])) {
				$valida = checkdate($valor[2],$valor[1],$valor[3]);
				if ($valor[3]<1970) $valida = 0;
			} else {
				$valida = 0;
			}
		} else {
			$valida = 0;
		}
		return $valida;
	}
?>