<?php
/** Copyright 2019
*
* Author: Ismael PONCE GORDILLO
*
* Licensed under the EUPL, Version 1.2 or – as soon they will be
* approved by the European Commission – subsequent versions of the
* EUPL (the "Licence"); you may not use this work except in
* compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* https://joinup.ec.europa.eu/software/page/eupl/licence-eupl
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the Licence is distributed on an "AS
* IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied.
* See the Licence for the specific language governing permissions
* and limitations under the Licence.
*/

if (isset($_SESSION['usuario'])) {
	if (!($conexion=mysqli_connect($MyHost,$MyUser,$MyPassword))) {
		echo "Error conectando a la base de datos.";
		exit();
	};
	if (!mysqli_select_db($conexion,$MyBBDD)) {
		echo "Error seleccionando la base de datos '$MyBBDD'.";
		echo mysqli_error();
		exit();
	};
	mysqli_query($conexion,"SET CHARACTER SET utf8");
	mysqli_query($conexion,"SET NAMES utf8");
	if (isset($_SESSION['Profe'])) {
		if (isset($_POST['CambiaGrupo'])) {
			$elementos=explode("|",$_POST['CambiaGrupo']);
			$_SESSION['anno']=$elementos[0];
			$_SESSION['codasignatura']=$elementos[1];
			$_SESSION['asignatura']=$elementos[2];
			$_SESSION['codcurso']=$elementos[3];
			$_SESSION['ensenanza']=$elementos[4];
			$_SESSION['nivel']=$elementos[5];
		}
		$SQL="SELECT DISTINCT curso.Código AS Curso, curso.Nivel AS Nivel, curso.Enseñanza AS Enseñanza, cursa.Año AS Año, asignaturas.Código AS CodAsignatura, asignaturas.Asignatura AS Asignatura FROM curso, cursa, asignaturas WHERE cursa.Asignatura=asignaturas.Código AND asignaturas.Curso=curso.Código ORDER BY cursa.Año DESC, curso.Nivel, curso.Enseñanza, asignaturas.Asignatura";
		$result=mysqli_query($conexion,$SQL);
		$grupos="";
		if ($result) {
			while($fila = mysqli_fetch_array($result)) {
				$elegido=($_SESSION['codasignatura']==$fila['CodAsignatura'] && $_SESSION['anno']==$fila['Año'])?"SELECTED":"";
				$grupos = $grupos . "<OPTION ". $elegido ." value='". $fila['Año'] ."|". $fila['CodAsignatura'] ."|". $fila['Asignatura'] ."|". $fila['Curso'] ."|". $fila['Enseñanza'] ."|". $fila['Nivel'] ."'>(". $fila['Año'] .") ". $fila['Nivel']."º".$fila['Enseñanza'] ." - ". $fila['Asignatura'] ."</OPTION>";
			};
			mysqli_free_result($result);
		} else { echo "Error: grupo profe - ". $SQL . mysqli_error(); }
		echo "<form action='index.php' method='post' name='selectgrupo'>";
		echo "<P ALIGN=CENTER>Bienvenido ".$_SESSION['usuario'].".<BR>";
		echo "<H6 ALIGN=CENTER>Curso y Asignatura: <BR><SELECT NAME='CambiaGrupo' onchange='this.form.submit()'>". $grupos ."</SELECT></H6></P></form>";
	} else {
		if (isset($_POST['CambiaGrupo'])) {
			$elementos=explode("|",$_POST['CambiaGrupo']);
			$_SESSION['codasignatura']=$elementos[0];
			$_SESSION['asignatura']=$elementos[1];
			$_SESSION['codcurso']=$elementos[2];
			$_SESSION['ensenanza']=$elementos[3];
			$_SESSION['nivel']=$elementos[4];
		}
		$SQL="SELECT DISTINCT curso.Código AS Curso, curso.Nivel AS Nivel, curso.Enseñanza AS Enseñanza, asignaturas.Código AS CodAsignatura, asignaturas.Asignatura AS Asignatura FROM curso, cursa, asignaturas WHERE cursa.Asignatura=asignaturas.Código AND asignaturas.Curso=curso.Código AND cursa.Alumno=".$_SESSION['codigo']." AND cursa.Año='".$_SESSION['anno']."' ORDER BY curso.Nivel, curso.Enseñanza, asignaturas.Asignatura";
		$result=mysqli_query($conexion,$SQL);
		$grupos="";
		if ($result) {
			while($fila = mysqli_fetch_array($result)) {
				$elegido=($_SESSION['codasignatura']==$fila['CodAsignatura'])?"SELECTED":"";
				$grupos = $grupos . "<OPTION ". $elegido ." value='". $fila['CodAsignatura'] ."|". $fila['Asignatura'] ."|". $fila['Curso'] ."|". $fila['Enseñanza'] ."|". $fila['Nivel'] ."'>". $fila['Nivel']."º".$fila['Enseñanza'] ." - ". $fila['Asignatura'] ."</OPTION>";
			};
			mysqli_free_result($result);
		} else { echo "Error: grupo alumno - ". $SQL . mysqli_error(); }
		echo "<form action='index.php' method='post' name='selectgrupo'>";
		echo "<P ALIGN=CENTER>Bienvenido ".$_SESSION['usuario'].".<BR>";
		echo "<H6 ALIGN=CENTER>Curso y Asignatura: <BR><SELECT NAME='CambiaGrupo' onchange='this.form.submit()'>". $grupos ."</SELECT></H6></P></form>";
	}
	mysqli_close($conexion);
} else {
	echo "<H6 ALIGN=CENTER>Usuario no identificado.</H6>";
};
?>