<?php
/** Copyright 2019
*
* Author: Ismael PONCE GORDILLO
*
* Licensed under the EUPL, Version 1.2 or – as soon they will be
* approved by the European Commission – subsequent versions of the
* EUPL (the "Licence"); you may not use this work except in
* compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* https://joinup.ec.europa.eu/software/page/eupl/licence-eupl
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the Licence is distributed on an "AS
* IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied.
* See the Licence for the specific language governing permissions
* and limitations under the Licence.
*/

if (!($conexion=mysqli_connect($MyHost,$MyUser,$MyPassword))) {
	echo "Error: p_alumnos conectando a la base de datos.";
	exit();
	};
if (!mysqli_select_db($conexion,$MyBBDD)) {
	echo "Error: p_alumnos seleccionando la base de datos '". $MyBBDD ."'.";
	exit();
};
mysqli_query($conexion,"SET CHARACTER SET utf8");
mysqli_query($conexion,"SET NAMES utf8");

if (!isset($_GET['op'])) {
	echo "<H2 ALIGN=CENTER>Lista de Alumnos: ".$_SESSION['nivel']."º".$_SESSION['ensenanza']." (".$_SESSION['anno'].")</H2>";
	$SQL="select DISTINCT datospersonales.Código as Código,Nombre,Apellidos,DNI from datospersonales,cursa,curso,asignaturas where datospersonales.Código=cursa.Alumno and cursa.Año='".$_SESSION['anno']."' and asignaturas.Código=cursa.Asignatura and asignaturas.Curso=curso.Código and curso.Código=".$_SESSION['codcurso']." order by Apellidos,Nombre";
//	$SQL="select * from datospersonales,cursa where datospersonales.Código=cursa.Alumno and cursa.Año='".$_SESSION['anno']."' and cursa.Asignatura='".$_SESSION['codasignatura']."' order by Apellidos,Nombre";
	$result=mysqli_query($conexion,$SQL);
	if ($result) {
		?>
		<TABLE ALIGN=CENTER BORDER=1 CELLSPACING=1 CELLPADDING=1>
		<THEAD>
			<TR>
				<TH ALIGN=CENTER><FONT SIZE=2>Acciones</FONT></TH>
				<TH ALIGN=CENTER><FONT SIZE=2>Editar</FONT></TH>
				<TH><FONT SIZE=2>Nombre</FONT></TH>
				<TH><FONT SIZE=2>Apellidos</FONT></TH>
				<TH><FONT SIZE=2>DNI</FONT></TH>
			</TR>
		</THEAD>
		<TBODY>
		<?php while($fila = mysqli_fetch_array($result)) {?>
			<TR>
				<TD ALIGN=CENTER>
					<A HREF='index.php?pag=profealumnos&op=borrar&codigo=<?php echo $fila['Código'];?>' onClick="return confirm('¿Esta seguro de querer borrar el alumno <?php echo $fila['Nombre']." ".$fila['Apellidos'];?> definitivamente?')" title="Para borrar completa y definitivamente el alumno."><FONT SIZE=2 COLOR="#ffff00">Borrar</FONT></A> / 
					<A HREF='index.php?pag=muta&codigo=<?php echo $fila['Código']."&usu=".$fila['Nombre']?>' title="Para convertirte en el alumno"><FONT SIZE=2 COLOR="#ffff00">Convertir en</FONT></A></TD>
				<TD ALIGN=CENTER>
					<A HREF='index.php?pag=profealumnos&op=editar&codigo=<?php echo $fila['Código'];?>' title="Para editar los datos de el alumno"><FONT SIZE=2 COLOR="#ffff00">Datos</FONT></A> / 
					<A HREF='index.php?pag=profealumnos&op=asignaturas&codigo=<?php echo $fila['Código'];?>' title="Para editar las asignaturas que cursa"><FONT SIZE=2 COLOR="#ffff00">Asignaturas</FONT></A>
				</TD>
				<TD><FONT SIZE=2><?php echo $fila['Nombre'];?></FONT></TD>
				<TD><FONT SIZE=2><?php echo $fila['Apellidos'];?></FONT></TD>
				<TD><FONT SIZE=2><?php echo $fila['DNI'];?></FONT></TD>
			</TR>
		<?php }; ?>
		</TBODY>
		</TABLE>
		<?php
		echo "<P ALIGN=CENTER>".mysqli_num_rows($result)." Alum@s (".date("d/m/Y").").</P>";
		mysqli_free_result($result);
		?> <TABLE  WIDTH=100% BORDER=0>
			<THEAD>
				<TR>
					<TH>
						<FORM NAME="Fotos" METHOD=POST ACTION="index.php?pag=profealumnos&op=fotos">
							<P ALIGN=RIGHT><INPUT TYPE=SUBMIT VALUE="Fotos"></P>
						</FORM>
					</TH>
					<TH>
						<FORM NAME="Simple" METHOD=POST ACTION="index.php?pag=profealumnos&op=simple">
							<P ALIGN=RIGHT><INPUT TYPE=SUBMIT VALUE="Lista Simple"></P>
						</FORM>
					</TH>
					<TH>
						<FORM NAME="DatosPersonales" METHOD=POST ACTION="index.php?pag=profealumnos&op=datospersonales">
							<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Lista Datos Personales"></P>
						</FORM>
					</TH>
					<TH>
						<FORM NAME="Anexo" METHOD=POST ACTION="index.php?pag=profealumnos&op=anexos">
							<P ALIGN=LEFT><INPUT TYPE=SUBMIT VALUE="Lista Anexos"></P>
						</FORM>
					</TH>
				</TR>
			</THEAD>
		</TABLE> <?php
	} else { echo "Error: p_alumnos lista por defecto - ". $SQL . mysqli_error($result);};
} elseif ($_GET['op']=="asignaturas") {
	if (isset($_POST['codasignatura'])) {
		if ($_POST['cursoInicio']>1990 && $_POST['cursoFin']>1990 && $_POST['cursoInicio']!=$_POST['cursoFin']) {
			$SQL="INSERT INTO cursa (Año,Alumno,Asignatura) VALUES ('".$_POST['cursoInicio']."-".$_POST['cursoFin']."',".$_GET['codigo'].",".$_POST['codasignatura'].");";
			if (!mysqli_query($conexion,$SQL)) {
			echo "<DL><DT>Los datos la asignatura a cursar, no han podido ser añadidos.(".mysqli_error().")</DT></DL>";
			}
		} else {
			echo "<DL><DT>Los datos la asignatura a cursar, no han sido guardados, los años del curso académico no son validos.</DT></DL>";
		};
	} elseif (isset($_GET['asignatura'])) {
		$SQL="delete from cursa where Año='".$_GET['anno']."' and Alumno=".$_GET['codigo']." and Asignatura=".$_GET['asignatura'];
//		echo $SQL." : ".mysqli_error();
		if (!mysqli_query($conexion,$SQL)) {
			echo "<DL><DT>Los datos la asignatura que cursaba, no han podido ser borrados.(".mysqli_error().")</DT></DL>";
		}
	}
	$SQL="select * from datospersonales where Código=".$_GET['codigo'];
	$result=mysqli_query($conexion,$SQL);
	$fila = mysqli_fetch_array($result);
	echo "<H2 ALIGN=CENTER>Lista de Asignaturas del alumn@ ".$fila['Apellidos'].",".$fila['Nombre'].": </H2>";
	mysqli_free_result($result);
	$SQL="select curso.Enseñanza AS Enseñanza, curso.Nivel AS Nivel, ";
	$SQL=$SQL."cursa.Año AS Año, cursa.Alumno AS Alumno, asignaturas.Código AS CódAsignatura, ";
	$SQL=$SQL."asignaturas.Asignatura AS Asignatura from curso, cursa, asignaturas ";
	$SQL=$SQL."where cursa.Alumno=".$_GET['codigo']." and cursa.Asignatura=asignaturas.Código ";
	$SQL=$SQL."and asignaturas.Curso=curso.Código order by cursa.Año, curso.Nivel DESC";
	$result=mysqli_query($conexion,$SQL);
	if ($result) {
		?>
		<TABLE ALIGN=CENTER BORDER=1 CELLSPACING=1 CELLPADDING=1>
		<THEAD>
			<TR>
				<TH ALIGN=CENTER><FONT SIZE=2>Acciones</FONT></TH>
				<TH><FONT SIZE=2>Asignatura</FONT></TH>
			</TR>
		</THEAD>
		<TBODY>
		<?php while($fila = mysqli_fetch_array($result)) {?>
			<TR>
				<TD ALIGN=CENTER>
					<?php if (mysqli_num_rows($result)>1) {?>
						<A HREF='index.php?pag=profealumnos&op=asignaturas&codigo=<?php echo $fila['Alumno'];?>&anno=<?php echo $fila['Año'];?>&asignatura=<?php echo $fila['CódAsignatura'];?>' 
						onClick="return confirm('¿Esta seguro de querer quitarlo de la asignatura <?php echo $fila['asignaturas.Asignatura'];?> definitivamente?')" title="Para borrar completa y definitivamente el alumno."><FONT SIZE=2 COLOR="#ffff00">Borrar</FONT></A>
					<?php } else { echo "&nbsp;"; };?>
				<TD><FONT SIZE=2><?php echo "(".$fila['Año'].") ".$fila['Nivel']."º".$fila['Enseñanza']." - ".$fila['Asignatura'];?></FONT></TD>
			</TR>
		<?php }; ?>
		</TBODY>
		</TABLE>
		<?php
		echo "<P ALIGN=CENTER>".mysqli_num_rows($result)." Asignaturas.</P>";
		mysqli_free_result($result);
		$SQL="select DISTINCT curso.Enseñanza AS Enseñanza, curso.Nivel AS Nivel, ";
		$SQL=$SQL."asignaturas.Código AS CódAsignatura, ";
		$SQL=$SQL."asignaturas.Asignatura AS Asignatura from curso, asignaturas ";
		$SQL=$SQL."where asignaturas.Curso=curso.Código order by curso.Nivel DESC";		
		$result=mysqli_query($conexion,$SQL);
		$asignaturas="";
		if ($result) {
			while($fila = mysqli_fetch_array($result)) {
				$asignaturas = $asignaturas . "<OPTION value='". $fila['CódAsignatura'] ."'>". $fila['Nivel'] ."º". $fila['Enseñanza'] ." - ". $fila['Asignatura'] ."</OPTION>";
			};
			mysqli_free_result($result);
		} else { echo "Error: alumno edit asignaturas - ". $SQL . mysqli_error(); }
		?> <TABLE  WIDTH=100% BORDER=0>
			<THEAD>
				<TR>
					<TH>
						<FORM NAME="addasig" METHOD=POST ACTION="index.php?pag=profealumnos&op=asignaturas&codigo=<?php echo $_GET['codigo']?>">
							<P ALIGN=CENTER>Curso: <INPUT TYPE=TEXT NAME='cursoInicio' VALUE=''> - <INPUT TYPE=TEXT NAME='cursoFin' VALUE=''>
							<P ALIGN=CENTER>Asignatura: <SELECT NAME='codasignatura'><?php echo $asignaturas; ?></SELECT>
							<INPUT TYPE=SUBMIT VALUE="Añadir"></P>
						</FORM>
					</TH>
				</TR>
			</THEAD>
		</TABLE> <?php
	}
} elseif ($_GET['op']=="fotospdf") {
	$SQL="select DISTINCT datospersonales.Código as Código,Nombre,Apellidos from datospersonales,cursa,curso,asignaturas where datospersonales.Código=cursa.Alumno and cursa.Año='".$_SESSION['anno']."' and asignaturas.Código=cursa.Asignatura and asignaturas.Curso=curso.Código and curso.Código=".$_SESSION['codcurso']." order by Apellidos,Nombre";
	$result=mysqli_query($conexion,$SQL);
	$pagina=iconv("UTF-8","ISO-8859-1","<H2 ALIGN=CENTER>Alumnos de ".$_SESSION['nivel']."º".$_SESSION['ensenanza'].", ".mysqli_num_rows($result)." Alum@s (".date("d/m/Y").").</H2>");
	if ($result) {
		$columna=1;
		$pagina=$pagina."<TABLE ALIGN=CENTER BORDER=2 CELLSPACING=2 CELLPADDING=2>\n";
		$pagina=$pagina."<TBODY>\n";
		while($fila = mysqli_fetch_array($result)) {
			if ($columna==1) {$pagina=$pagina."<TR>\n";};
			$pagina=$pagina."<TD VALIGN=TOP ALIGN=CENTER><img width=108 height=135 src='archivos/Fotos/".$fila['Código'].".jpg'><BR>";
			$pagina=$pagina.iconv("UTF-8","ISO-8859-1","<H1><B>".$fila['Apellidos'].", ".$fila['Nombre']."</B></H1></TD>\n");
			if ($columna==5) {$pagina=$pagina."</TR>\n";$columna=0;};
			$columna=$columna+1;
		}
		if ($columna!=1) {
			for (;$columna<=5;$columna=$columna+1) {$pagina=$pagina."<TD>&nbsp;</TD>\n";};
			$pagina=$pagina."</TR>\n";$columna=1;
		}
		$pagina=$pagina."</TBODY>\n";
		$pagina=$pagina."</TABLE>\n";
		echo "Guardando en Archivos como ".date("Y_m_d_").$_SESSION['nivel']."o".$_SESSION['ensenanza']."_".str_replace("-","_",$_SESSION['anno']).".pdf<br>";
		echo shell_exec("echo '$pagina' > /tmp/".date("Y_m_d_")."generapdfprueba.html");
		echo shell_exec("echo '$pagina'| html2ps > /tmp/".date("Y_m_d_")."generapdfprueba.ps");
		echo shell_exec("ps2pdf /tmp/".date("Y_m_d_")."generapdfprueba.ps /var/www/pruebas/http/archivos/".date("Y_m_d_").$_SESSION['nivel']."o".$_SESSION['ensenanza']."_".str_replace("-","_",$_SESSION['anno']).".pdf");
//		unlink("/tmp/".date("Y_m_d_")."generapdfprueba.ps");
	}
	?> <TABLE  WIDTH=100% BORDER=0>
		<THEAD>
			<TR>
				<TH>
					<FORM NAME="Fotos" METHOD=POST ACTION="index.php?pag=profealumnos&op=fotos">
						<P ALIGN=RIGHT><INPUT TYPE=SUBMIT VALUE="Fotos"></P>
					</FORM>
				</TH>
				<TH>
					<FORM NAME="Simple" METHOD=POST ACTION="index.php?pag=profealumnos&op=simple">
						<P ALIGN=RIGHT><INPUT TYPE=SUBMIT VALUE="Lista Simple"></P>
					</FORM>
				</TH>
				<TH>
					<FORM NAME="DatosPersonales" METHOD=POST ACTION="index.php?pag=profealumnos&op=datospersonales">
						<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Lista Datos Personales"></P>
					</FORM>
				</TH>
				<TH>
					<FORM NAME="Anexo" METHOD=POST ACTION="index.php?pag=profealumnos&op=anexos">
						<P ALIGN=LEFT><INPUT TYPE=SUBMIT VALUE="Lista Anexo"></P>
					</FORM>
				</TH>
			</TR>
		</THEAD>
	</TABLE> <?php
} elseif ($_GET['op']=="fotos") {
	$SQL="select DISTINCT datospersonales.Código as Código,Nombre,Apellidos from datospersonales,cursa,curso,asignaturas where datospersonales.Código=cursa.Alumno and cursa.Año='".$_SESSION['anno']."' and asignaturas.Código=cursa.Asignatura and asignaturas.Curso=curso.Código and curso.Código=".$_SESSION['codcurso']." order by Apellidos,Nombre";
	$result=mysqli_query($conexion,$SQL);
	echo "<H2 ALIGN=CENTER>Alumnos de ".$_SESSION['nivel']."º".$_SESSION['ensenanza'].", ".mysqli_num_rows($result)." Alum@s (".date("d/m/Y").").</H2>";
	if ($result) {
		$columna=1;
		echo "<TABLE ALIGN=CENTER BORDER=1 CELLSPACING=1 CELLPADDING=1>\n";
		echo "<TBODY>\n";
		while($fila = mysqli_fetch_array($result)) {
			if ($columna==1) {echo "<TR>\n";};
			echo "<TD VALIGN=TOP ALIGN=CENTER><img width=108 height=135 src='archivos/Fotos/".$fila['Código'].".jpg'><BR>";
			echo "<H6>".$fila['Apellidos'].", ".$fila['Nombre']."</H6></TD>\n";
			if ($columna==5) {echo "</TR>\n";$columna=0;};
			$columna=$columna+1;
		}
		if ($columna!=1) {
			for (;$columna<=5;$columna=$columna+1) {echo "<TD>&nbsp;</TD>\n";};
			echo "</TR>\n";$columna=1;
		}
		echo "</TBODY>\n";
		echo "</TABLE>\n";
	}
	?> <TABLE  WIDTH=100% BORDER=0>
		<THEAD>
			<TR>
				<TH>
					<FORM NAME="FotosPDF" METHOD=POST ACTION="index.php?pag=profealumnos&op=fotospdf">
						<P ALIGN=RIGHT><INPUT TYPE=SUBMIT VALUE="Genera pdf"></P>
					</FORM>
				</TH>
				<TH>
					<FORM NAME="Fotos" METHOD=POST ACTION="index.php?pag=profealumnos&op=fotos">
						<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Fotos"></P>
					</FORM>
				</TH>
				<TH>
					<FORM NAME="Simple" METHOD=POST ACTION="index.php?pag=profealumnos&op=simple">
						<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Lista Simple"></P>
					</FORM>
				</TH>
				<TH>
					<FORM NAME="DatosPersonales" METHOD=POST ACTION="index.php?pag=profealumnos&op=datospersonales">
						<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Lista Datos Personales"></P>
					</FORM>
				</TH>
				<TH>
					<FORM NAME="Anexo" METHOD=POST ACTION="index.php?pag=profealumnos&op=anexos">
						<P ALIGN=LEFT><INPUT TYPE=SUBMIT VALUE="Lista Anexo"></P>
					</FORM>
				</TH>
			</TR>
		</THEAD>
	</TABLE> <?php
} elseif ($_GET['op']=="simple" || $_GET['op']=="datospersonales" || $_GET['op']=="anexos") {
	if ($_GET['op']=="datospersonales") {
		echo "<H2 ALIGN=CENTER>Lista de Alumnos (Datos Personales): ".$_SESSION['nivel']."º".$_SESSION['ensenanza']." (".$_SESSION['anno'].")</H2>";
	} else if ($_GET['op']=="anexos") {
		echo "<H2 ALIGN=CENTER>Lista de Alumnos (Datos Anexos): ".$_SESSION['nivel']."º".$_SESSION['ensenanza']." (".$_SESSION['anno'].")</H2>";
	} else {
		echo "<H2 ALIGN=CENTER>Lista de Alumnos: ".$_SESSION['nivel']."º".$_SESSION['ensenanza']." (".$_SESSION['anno'].")</H2>";
	}
	$SQL="select DISTINCT datospersonales.Código as Código,Nombre,Apellidos,DNI,Nacimiento,Dirección,Población,Postal,Tutor,Teléfono,Móvil,Email,Coche,Ordenador,Internet,Estudios,Cursos,Trabajos from datospersonales,cursa,curso,asignaturas where datospersonales.Código=cursa.Alumno and cursa.Año='".$_SESSION['anno']."' and asignaturas.Código=cursa.Asignatura and asignaturas.Curso=curso.Código and curso.Código=".$_SESSION['codcurso']." order by Apellidos,Nombre";
//	$SQL="select * from datospersonales,cursa where datospersonales.Código=cursa.Alumno and cursa.Año='".$_SESSION['anno']."' and cursa.Asignatura='".$_SESSION['codasignatura']."' order by Apellidos,Nombre";
	$result=mysqli_query($conexion,$SQL);
	if ($result) {
		?>
		<TABLE ALIGN=CENTER BORDER=1 CELLSPACING=1 CELLPADDING=1>
		<THEAD>
			<TR>
				<?php if ($_GET['op']=="simple") {?>
					<TH>Foto</TH>
					<TH>Nombre</TH>
					<TH>Apellidos</TH>
				<?php } elseif ($_GET['op']=="datospersonales") {?>
					<TH>Foto</TH>
					<TH><FONT SIZE=1>Nombre</FONT></TH>
					<TH><FONT SIZE=1>Apellidos</FONT></TH>
					<TH><FONT SIZE=1>DNI</FONT></TH>
					<TH><FONT SIZE=1>Naci&oacute;</FONT></TH>
					<TH><FONT SIZE=1>Direcci&oacute;n</FONT></TH>
					<TH><FONT SIZE=1>Poblaci&oacute;n</FONT></TH>
					<TH><FONT SIZE=1>Postal</FONT></TH>
					<TH><FONT SIZE=1>Tutor</FONT></TH>
					<TH><FONT SIZE=1>Tel&eacute;fono</FONT></TH>
					<TH><FONT SIZE=1>M&oacute;vil</FONT></TH>
					<TH><FONT SIZE=1>Email</FONT></TH>
				<?php } elseif ($_GET['op']=="anexos") {?>
					<TH>Foto</TH>
					<TH><FONT SIZE=1>Nombre</FONT></TH>
					<TH><FONT SIZE=1>Apellidos</FONT></TH>
					<TH><FONT SIZE=1>DNI</FONT></TH>
					<TH><FONT SIZE=1>Car</FONT></TH>
					<TH><FONT SIZE=1>PC</FONT></TH>
					<TH><FONT SIZE=1>Inet</FONT></TH>
					<TH><FONT SIZE=1>Estudios</FONT></TH>
					<TH><FONT SIZE=1>Cursos</FONT></TH>
					<TH><FONT SIZE=1>Trabajos</FONT></TH>
				<?php } ?>
			</TR>
		</THEAD>
		<TBODY>
			<?php while($fila = mysqli_fetch_array($result)) {?>
				<TR>
					<?php if ($_GET['op']=="simple") {?>
						<TD VALIGN=TOP ALIGN=CENTER><img width=36 height=45 src='archivos/Fotos/<?php echo $fila['Código'];?>.jpg'></TD>
						<TD><?php echo $fila['Nombre'];?></TD>
						<TD><?php echo $fila['Apellidos'];?></TD>
					<?php } elseif ($_GET['op']=="datospersonales") {?>
						<TD VALIGN=TOP ALIGN=CENTER><img width=18 height=23 src='archivos/Fotos/<?php echo $fila['Código'];?>.jpg'></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Nombre']=="")?"&nbsp;":$fila['Nombre'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Apellidos']=="")?"&nbsp;":$fila['Apellidos'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['DNI']=="")?"&nbsp;":$fila['DNI'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Nacimiento']=="")?"&nbsp;":substr($fila['Nacimiento'],8,2)."/".substr($fila['Nacimiento'],5,2)."/".substr($fila['Nacimiento'],0,4);?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Dirección']=="")?"&nbsp;":$fila['Dirección'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Población']=="")?"&nbsp;":$fila['Población'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Postal']=="")?"&nbsp;":$fila['Postal'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Tutor']=="")?"&nbsp;":$fila['Tutor'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Teléfono']=="")?"&nbsp;":$fila['Teléfono'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Móvil']=="")?"&nbsp;":$fila['Móvil'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Email']=="")?"&nbsp;":$fila['Email'];?></FONT></TD>
					<?php } elseif ($_GET['op']=="anexos") {?>
						<TD VALIGN=TOP ALIGN=CENTER><img width=18 height=23 src='archivos/Fotos/<?php echo $fila['Código'];?>.jpg'></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Nombre']=="")?"&nbsp;":$fila['Nombre'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Apellidos']=="")?"&nbsp;":$fila['Apellidos'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['DNI']=="")?"&nbsp;":$fila['DNI'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Coche']=="")?"&nbsp;":$fila['Coche'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Ordenador']=="")?"&nbsp;":$fila['Ordenador'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Internet']=="")?"&nbsp;":$fila['Internet'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Estudios']=="")?"&nbsp;":$fila['Estudios'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Cursos']=="")?"&nbsp;":$fila['Cursos'];?></FONT></TD>
						<TD><FONT SIZE=1><?php echo ($fila['Trabajos']=="")?"&nbsp;":$fila['Trabajos'];?></FONT></TD>
					<?php } ?>
				</TR>
			<?php }; ?>
		</TBODY>
		</TABLE>
		<?php
		echo "<P ALIGN=CENTER>".mysqli_num_rows($result)." Alumn@s (".date("d/m/Y").").</P>";
		mysqli_free_result($result);
		?> <TABLE  WIDTH=100% BORDER=0>
			<THEAD>
				<TR>
					<TH>
						<FORM NAME="Fotos" METHOD=POST ACTION="index.php?pag=profealumnos&op=fotos">
							<P ALIGN=RIGHT><INPUT TYPE=SUBMIT VALUE="Fotos"></P>
						</FORM>
					</TH>
					<TH>
						<FORM NAME="Simple" METHOD=POST ACTION="index.php?pag=profealumnos&op=simple">
							<P ALIGN=RIGHT><INPUT TYPE=SUBMIT VALUE="Lista Simple"></P>
						</FORM>
					</TH>
					<TH>
						<FORM NAME="DatosPersonales" METHOD=POST ACTION="index.php?pag=profealumnos&op=datospersonales">
							<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Lista Datos Personales"></P>
						</FORM>
					</TH>
					<TH>
						<FORM NAME="Anexo" METHOD=POST ACTION="index.php?pag=profealumnos&op=anexos">
							<P ALIGN=LEFT><INPUT TYPE=SUBMIT VALUE="Lista Anexo"></P>
						</FORM>
					</TH>
				</TR>
			</THEAD>
		</TABLE> <?php
	}
} elseif ($_GET['op']=="editar") {
	$formulario=0;
	echo "<H2 ALIGN=CENTER>Editando un alumn@:</H2>";
	if (!isset($_POST['Nombre'])) {
		$formulario=1;
	} elseif ($_POST['Nombre']=="") {
		echo "<H2 ALIGN=CENTER><FONT COLOR='#ff0000'>¡Error, introduzca un nombre!</FONT></H2>";
		$formulario=1;
	} elseif ($_POST['Apellidos']=="") {
		echo "<H2 ALIGN=CENTER><FONT COLOR='#ff0000'>¡Error, introduzca los apellidos!</FONT></H2>";
		$formulario=1;
	} elseif ($_POST['DNI']=="") {
		echo "<H2 ALIGN=CENTER><FONT COLOR='#ff0000'>¡Error, introduzca el DNI!</FONT></H2>";
		$formulario=1;
	} elseif ($_POST['MesNac']=="" || $_POST['DiaNac']=="" || $_POST['AnoNac']=="") {
		echo "<H2 ALIGN=CENTER><FONT COLOR='#ff0000'>¡Error, introduzca una fecha de nacimiento correcta!</FONT></H2>";
		$formulario=1;
	} elseif (! checkdate($_POST['MesNac'],$_POST['DiaNac'],$_POST['AnoNac'])) {
		echo "<H2 ALIGN=CENTER><FONT COLOR='#ff0000'>¡Error, introduzca una fecha de nacimiento correcta!</FONT></H2>";
		$formulario=1;
	} else {				// Los datos son validos
		if (is_uploaded_file($_FILES['Foto']['tmp_name'])) {
			if($_FILES['Foto']['size'] < 1048576) {
				$salida=copy($_FILES['Foto']['tmp_name'], "/tmp/" . $_GET['codigo']."_a.jpg");
				$salida=shell_exec("convert /tmp/" . $_GET['codigo']."_a.jpg -resize x450 -pointsize 300 /tmp/" . $_GET['codigo']."_b.jpg");
				$ancho=shell_exec("identify -format '%w' /tmp/" . $_GET['codigo']."_b.jpg");
				$ancho=round(($ancho-360)/2);
				$salida=shell_exec("convert /tmp/" . $_GET['codigo']."_b.jpg -crop 360x450+".$ancho."+0 /var/www/pruebas/http/archivos/Fotos/" . $_GET['codigo'].".jpg");
				unlink("/tmp/" . $_GET['codigo']."_b.jpg");
				unlink("/tmp/" . $_GET['codigo']."_a.jpg");
 			}
		}

?>
		<P ALIGN=CENTER><img width=36 height=45 src="archivos/Fotos/<?php echo $_GET['codigo'];?>.jpg"></P>
		<UL>
			<LI><DD><B>Curso: </B><?php echo $_SESSION['anno'];?></DD>
			<BR>
			<LI><DD><B>Nombre: </B><?php echo $_POST['Nombre'];?></DD>
			<LI><DD><B>Apellidos: </B><?php echo $_POST['Apellidos'];?></DD>
			<LI><DD><B>DNI: </B><?php echo $_POST['DNI'];?></DD>
			<LI><DD><B>Nació: </B><?php echo $_POST['DiaNac']."/".$_POST['MesNac']."/".$_POST['AnoNac'];?></DD>
			<LI><DD><B>Tutor: </B><?php echo $_POST['Tutor'];?></DD>
			<LI><DD><B>Direcci&oacute;n: </B><?php echo $_POST['Direccion'];?></DD>
			<LI><DD><B>Poblaci&oacute;n: </B><?php echo $_POST['Poblacion'];?></DD>
			<LI><DD><B>C&oacute;digo Postal: </B><?php echo $_POST['Postal'];?></DD>
			<LI><DD><B>Tel&eacute;fono: </B><?php echo $_POST['Telefono'];?></DD>
			<LI><DD><B>M&oacute;vil: </B><?php echo $_POST['Movil'];?></DD>
			<LI><DD><B>Email: </B><?php echo $_POST['Email'];?></DD>
			<LI><DD><B>Coche Disponible: </B><?php echo (isset($_POST['Coche']))?"Si":"No";?></DD>
			<LI><DD><B>Ordenador Personal: </B><?php echo (isset($_POST['Ordenador']))?"Si":"No";?></DD>
			<LI><DD><B>Conexi&oacute;n a Internet: </B><?php echo (isset($_POST['Internet']))?"Si":"No";?></DD>
			<LI><DD><B>Estudios: </B><?php echo $_POST['Estudios'];?></DD>
			<LI><DD><B>Cursos: </B><?php echo $_POST['Cursos'];?></DD>
			<LI><DD><B>Trabajos: </B><?php echo $_POST['Trabajos'];?></DD></UL>
		<?php						// Actualiza los Datos
		$SQL="UPDATE datospersonales SET Clave='".md5($_POST['Clave'])."',Apellidos='".$_POST['Apellidos']."',";
		$SQL=$SQL."Nombre='".$_POST['Nombre']."',DNI=".$_POST['DNI'].",Nacimiento='".$_POST['AnoNac']."-".$_POST['MesNac']."-".$_POST['DiaNac']."',";
		$SQL=$SQL."Dirección='".$_POST['Direccion']."',Población='".$_POST['Poblacion']."',Postal='".$_POST['Postal']."',";
		$SQL=$SQL."Tutor='".$_POST['Tutor']."',Teléfono='".$_POST['Telefono']."',Móvil='".$_POST['Movil']."',Email='".$_POST['Email']."',";
		$SQL=$SQL."Coche='".((isset($_POST['Coche']))?"Si":"No")."',Ordenador='".((isset($_POST['Ordenador'])?"Si":"No"))."',Internet='".((isset($_POST['Internet']))?"Si":"No")."',";
		$SQL=$SQL."Estudios='".$_POST['Estudios']."',Cursos='".$_POST['Cursos']."',Trabajos='".$_POST['Trabajos']."' WHERE Código=".$_GET['codigo'];
		if (!mysqli_query($conexion,$SQL)) {
			echo "<DL><DT>Los datos personales no han podido ser actualizados.";
			echo "<UL><LI><DD>SQL: ".$SQL."</DD>";
			echo "<LI><DD>".mysqli_error()."</DD></DT></DL>";
		} else {
			echo "<DL><DT>Los datos personales han sido actualizados.</DT></DL>";
		};
	};
	if ($formulario) {
		if (isset($_POST['Nombre'])) {		//No validos
			?> <FORM NAME="Datos" METHOD=POST ENCTYPE="multipart/form-data" ACTION="index.php?pag=profealumnos&op=editar&codigo=<?php echo $_GET['codigo'];?>">
				<P ALIGN=CENTER>Nombre: <INPUT TYPE=TEXT NAME="Nombre" SIZE=12 MAXLENGTH=50 VALUE="<?php echo (isset($_POST['Nombre']))?$_POST['Nombre']:'';?>">
				Apellidos: 				<INPUT TYPE=TEXT NAME="Apellidos" SIZE=24 MAXLENGTH=100 VALUE="<?php echo (isset($_POST['Apellidos']))?$_POST['Apellidos']:'';?>">
				DNI: 					<INPUT TYPE=TEXT NAME="DNI" SIZE=8 MAXLENGTH=8 VALUE="<?php echo (isset($_POST['DNI']))?$_POST['DNI']:'';?>"></P>
				<P ALIGN=CENTER>Nació: <INPUT TYPE=TEXT NAME="DiaNac" SIZE=2 MAXLENGTH=2 VALUE="<?php echo (isset($_POST['DiaNac']))?$_POST['DiaNac']:'';?>">
				/<INPUT TYPE=TEXT NAME="MesNac" SIZE=2 MAXLENGTH=2 VALUE="<?php echo (isset($_POST['MesNac']))?$_POST['MesNac']:'';?>">
				/<INPUT TYPE=TEXT NAME="AnoNac" SIZE=4 MAXLENGTH=4 VALUE="<?php echo (isset($_POST['AnoNac']))?$_POST['AnoNac']:'';?>"> 
				Tutor: 	<INPUT TYPE=TEXT NAME="Tutor" SIZE=64 MAXLENGTH=100 VALUE="<?php echo (isset($_POST['Tutor']))?$_POST['Tutor']:'';?>"></P>
				<P ALIGN=CENTER>Direcci&oacute;n: 	<INPUT TYPE=TEXT NAME="Direccion" SIZE=24 MAXLENGTH=100 VALUE="<?php echo (isset($_POST['Direccion']))?$_POST['Direccion']:'';?>">
				Poblaci&oacute;n: 					<INPUT TYPE=TEXT NAME="Poblacion" SIZE=12 MAXLENGTH=50 VALUE="<?php echo (isset($_POST['Poblacion']))?$_POST['Poblacion']:'';?>">
				C&oacute;digo Postal: 				<INPUT TYPE=TEXT NAME="Postal" SIZE=5 MAXLENGTH=5 VALUE="<?php echo (isset($_POST['Postal']))?$_POST['Postal']:'';?>"></P>
				<P ALIGN=CENTER>Tel&eacute;fono: 	<INPUT TYPE=TEXT NAME="Telefono" SIZE=9 MAXLENGTH=9 VALUE="<?php echo (isset($_POST['Telefono']))?$_POST['Telefono']:'';?>">
				M&oacute;vil: 						<INPUT TYPE=TEXT NAME="Movil" SIZE=9 MAXLENGTH=9 VALUE="<?php echo (isset($_POST['Movil']))?$_POST['Movil']:'';?>">
				Email: 								<INPUT TYPE=TEXT NAME="Email" SIZE=32 MAXLENGTH=150 VALUE="<?php echo (isset($_POST['Email']))?$_POST['Email']:'';?>"></P>
				<P ALIGN=CENTER>Coche Disponible: 	<INPUT TYPE=CHECKBOX NAME="Coche" VALUE="" <?php echo (isset($_POST['Coche']))?"CHECKED":"";?>>
				Ordenador Personal: 				<INPUT TYPE=CHECKBOX NAME="Ordenador" VALUE="" <?php echo (isset($_POST['Ordenador']))?"CHECKED":"";?>>
				Conexi&oacute;n a Internet: 		<INPUT TYPE=CHECKBOX NAME="Internet" VALUE="" <?php echo (isset($_POST['Internet']))?"CHECKED":"";?>></P>
				<P ALIGN=CENTER>Estudios: 	<TEXTAREA NAME="Estudios" ROWS=3 COLS=60><?php echo (isset($_POST['Estudios']))?$_POST['Estudios']:'';?></TEXTAREA></P>
				<P ALIGN=CENTER>Cursos: 	<TEXTAREA NAME="Cursos" ROWS=3 COLS=60><?php echo (isset($_POST['Cursos']))?$_POST['Cursos']:'';?></TEXTAREA></P>
				<P ALIGN=CENTER>Trabajos: 	<TEXTAREA NAME="Trabajos" ROWS=3 COLS=60><?php echo (isset($_POST['Trabajos']))?$_POST['Trabajos']:'';?></TEXTAREA></P>
				<P ALIGN=CENTER>Foto: <INPUT TYPE=FILE NAME="Foto">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE=SUBMIT VALUE="Enviar y Actualizar Datos"></P>
			</FORM>
		<?php } else {	// Recuperarlo datos de la BBDD
			$SQL="select * from datospersonales where Código=".$_GET['codigo'];
			$result=mysqli_query($conexion,$SQL);
			if ($result) {
				if ($fila = mysqli_fetch_array($result)) {

					?>
					<FORM NAME="Datos" METHOD=POST ENCTYPE="multipart/form-data" ACTION="index.php?pag=profealumnos&op=editar&codigo=<?php echo $_GET['codigo'];?>">
						<P ALIGN=CENTER>Nombre: <INPUT TYPE=TEXT NAME="Nombre" SIZE=12 MAXLENGTH=50 VALUE="<?php echo $fila['Nombre'];?>">
						Apellidos: 				<INPUT TYPE=TEXT NAME="Apellidos" SIZE=24 MAXLENGTH=100 VALUE="<?php echo $fila['Apellidos'];?>">
						DNI: 					<INPUT TYPE=TEXT NAME="DNI" SIZE=8 MAXLENGTH=8 VALUE="<?php echo $fila['DNI'];?>"></P>
						<P ALIGN=CENTER>Nació: <INPUT TYPE=TEXT NAME="DiaNac" SIZE=2 MAXLENGTH=2 VALUE="<?php echo substr($fila['Nacimiento'],8,2);?>">
						/<INPUT TYPE=TEXT NAME="MesNac" SIZE=2 MAXLENGTH=2 VALUE="<?php echo substr($fila['Nacimiento'],5,2);?>">
						/<INPUT TYPE=TEXT NAME="AnoNac" SIZE=4 MAXLENGTH=4 VALUE="<?php echo substr($fila['Nacimiento'],0,4);?>"> 
						Tutor: <INPUT TYPE=TEXT NAME="Tutor" SIZE=64 MAXLENGTH=100 VALUE="<?php echo $fila['Tutor'];?>"></P>
						<P ALIGN=CENTER>Direcci&oacute;n: 	<INPUT TYPE=TEXT NAME="Direccion" SIZE=24 MAXLENGTH=100 VALUE="<?php echo $fila['Dirección'];?>">
						Poblaci&oacute;n: 					<INPUT TYPE=TEXT NAME="Poblacion" SIZE=12 MAXLENGTH=50 VALUE="<?php echo $fila['Población'];?>">
						C&oacute;digo Postal: 				<INPUT TYPE=TEXT NAME="Postal" SIZE=5 MAXLENGTH=5 VALUE="<?php echo $fila['Postal'];?>"></P>
						<P ALIGN=CENTER>Tel&eacute;fono: 	<INPUT TYPE=TEXT NAME="Telefono" SIZE=9 MAXLENGTH=9 VALUE="<?php echo $fila['Teléfono'];?>">
						M&oacute;vil: 						<INPUT TYPE=TEXT NAME="Movil" SIZE=9 MAXLENGTH=9 VALUE="<?php echo $fila['Móvil'];?>">
						Email: 								<INPUT TYPE=TEXT NAME="Email" SIZE=32 MAXLENGTH=150 VALUE="<?php echo $fila['Email'];?>"></P>
						<P ALIGN=CENTER>Coche Disponible: 	<INPUT TYPE=CHECKBOX NAME="Coche" VALUE="" <?php echo ($fila['Coche']=='Si')?"CHECKED":"";?>>
						Ordenador Personal: 				<INPUT TYPE=CHECKBOX NAME="Ordenador" VALUE="" <?php echo ($fila['Ordenador']=='Si')?"CHECKED":"";?>>
						Conexi&oacute;n a Internet: 		<INPUT TYPE=CHECKBOX NAME="Internet" VALUE="" <?php echo ($fila['Internet']=='Si')?"CHECKED":"";?>></P>
						<P ALIGN=CENTER>Estudios: 	<TEXTAREA NAME="Estudios" ROWS=3 COLS=60><?php echo $fila['Estudios'];?></TEXTAREA></P>
						<P ALIGN=CENTER>Cursos: 	<TEXTAREA NAME="Cursos" ROWS=3 COLS=60><?php echo $fila['Cursos'];?></TEXTAREA></P>
						<P ALIGN=CENTER>Trabajos: 	<TEXTAREA NAME="Trabajos" ROWS=3 COLS=60><?php echo $fila['Trabajos'];?></TEXTAREA></P>
						<P ALIGN=CENTER>Foto: <INPUT TYPE="file" NAME="Foto">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE=SUBMIT VALUE="Enviar y Actualizar Datos"></P>
					</FORM>
				<?php } else {
					echo "Registro no encontrado";
				}
			}
			mysqli_free_result($result);
		}
	}
} elseif ($_GET['op']=="borrar") {
	$SQL="select * from datospersonales where Código=".$_GET['codigo'];
	$result=mysqli_query($conexion,$SQL);
	$fila = mysqli_fetch_array($result)
	?> <H2 ALIGN=CENTER>Borrando el alumno:</H2>
		<UL>
			<LI><DD><B>Nombre: </B><?php echo $fila['Nombre'];?></DD>
			<LI><DD><B>Apellidos: </B><?php echo $fila['Apellidos'];?></DD>
			<LI><DD><B>DNI: </B><?php echo $fila['DNI'];?></DD>
			<LI><DD><B>Direcci&oacute;n: </B><?php echo $fila['Dirección'];?></DD>
			<LI><DD><B>Nació: </B><?php echo $fila['Nacimiento'];?></DD>
			<LI><DD><B>Tutor: </B><?php echo $fila['Tutor'];?></DD>
			<LI><DD><B>Poblaci&oacute;n: </B><?php echo $fila['Población'];?></DD>
			<LI><DD><B>C&oacute;digo Postal: </B><?php echo $fila['Postal'];?></DD>
			<LI><DD><B>Tel&eacute;fono: </B><?php echo $fila['Teléfono'];?></DD>
			<LI><DD><B>M&oacute;vil: </B><?php echo $fila['Móvil'];?></DD>
			<LI><DD><B>Email: </B><?php echo $fila['Email'];?></DD>
			<LI><DD><B>Coche Disponible: </B><?php echo (isset($fila['Coche']))?"Si":"No";?></DD>
			<LI><DD><B>Ordenador Personal: </B><?php echo (isset($fila['Ordenador']))?"Si":"No";?></DD>
			<LI><DD><B>Conexi&oacute;n a Internet: </B><?php echo (isset($fila['Internet']))?"Si":"No";?></DD>
			<LI><DD><B>Estudios: </B><?php echo $fila['Estudios'];?></DD>
			<LI><DD><B>Cursos: </B><?php echo $fila['Cursos'];?></DD>
			<LI><DD><B>Trabajos: </B><?php echo $fila['Trabajos'];?></DD></UL>
	<?php
	mysqli_free_result($result);
	$SQL="delete from respuestas where Alumno=".$_GET['codigo'];
	if (!mysqli_query($conexion,$SQL)) {
		echo "<DL><DT>Los datos de las respuestas no han podido ser borrados.(".mysqli_error().")</DT></DL>";
	} else {
		echo "<DL><DT>Los datos de las respuestas han sido borrados.</DT></DL>";
	}
	$SQL="delete from accesos where Alumno=".$_GET['codigo'];
	if (!mysqli_query($conexion,$SQL)) {
		echo "<DL><DT>Los datos de los accesos no han podido ser borrados.(".mysqli_error().")</DT></DL>";
	} else {
		echo "<DL><DT>Los datos de los accesos han sido borrados.</DT></DL>";
	}
	$SQL="delete from cursa where Alumno=".$_GET['codigo'];
	if (!mysqli_query($conexion,$SQL)) {
		echo "<DL><DT>Los datos lo que cursó no han podido ser borrados.(".mysqli_error().")</DT></DL>";
	} else {
		echo "<DL><DT>Los datos lo que cursó han sido borrados.</DT></DL>";
	}
	$SQL="delete from datospersonales where Código=".$_GET['codigo'];
	if (!mysqli_query($conexion,$SQL)) {
		echo "<DL><DT>Los datos personales no han podido ser borrados.(".mysqli_error().")</DT></DL>";
	} else {
		echo "<DL><DT>Los datos personales han sido borrados.</DT></DL>";
	}
	?>
	<FORM NAME='borrado' METHOD=POST ACTION="index.php?pag=profealumnos">
		<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Volver a Alumnos"></P>
	</FORM> <?php
};
mysqli_close($conexion);
?>

