<?php
/** Copyright 2019
*
* Author: Ismael PONCE GORDILLO
*
* Licensed under the EUPL, Version 1.2 or – as soon they will be
* approved by the European Commission – subsequent versions of the
* EUPL (the "Licence"); you may not use this work except in
* compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* https://joinup.ec.europa.eu/software/page/eupl/licence-eupl
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the Licence is distributed on an "AS
* IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied.
* See the Licence for the specific language governing permissions
* and limitations under the Licence.
*/

include($MyFiles . "fecha.inc");
if (!($conexion=mysqli_connect($MyHost,$MyUser,$MyPassword))) {
	echo "Error: p_encuestas conectando a la base de datos.";
	exit();
};
if (!mysqli_select_db($conexion,$MyBBDD)) {
	echo "Error: p_encuestas seleccionando la base de datos '".$MyBBDD."'.";
	exit();
};
mysqli_query($conexion,"SET CHARACTER SET utf8");
mysqli_query($conexion,"SET NAMES utf8");

if (!isset($_GET['op'])) {
	echo "<H2 ALIGN=CENTER>Encuestas: ".$_SESSION['nivel']."º ".$_SESSION['ensenanza']." - ".$_SESSION['asignatura']."</H2>";
	$SQL="select * from encuestas where Asignatura=".$_SESSION['codasignatura']." order by Fecha";
	$result=mysqli_query($conexion,$SQL);
	?>
	<TABLE ALIGN=CENTER BORDER=1 CELLSPACING=1 CELLPADDING=1>
	<THEAD>
		<TR>
			<TH ALIGN=CENTER><FONT SIZE=2>Estado</FONT></TH>
			<TH ALIGN=CENTER><FONT SIZE=2>Ver</FONT></TH>
			<TH ALIGN=CENTER><FONT SIZE=2>Borrar</FONT></TH>
			<TH ALIGN=CENTER><FONT SIZE=2>Editar</FONT></TH>
			<TH ALIGN=CENTER><FONT SIZE=2>Título</FONT></TH>
			<TH ALIGN=CENTER><FONT SIZE=2>Fecha</FONT></TH>
		</TR>
	</THEAD>
	<TBODY>
		<?php while($fila = mysqli_fetch_array($result)) {?>
		<TR>
			<?php if ($fila['Activa']=="No") {?>
			<TD ALIGN=CENTER><FONT SIZE=3><A HREF='index.php?pag=profeencuestas&op=activar&codigo=<?php echo $fila['Código'];?>'><FONT COLOR="#00ff00"><B>Desactivada</B></FONT></A></FONT></TD>
			<?php } else { ?>
			<TD ALIGN=CENTER><FONT SIZE=3><A HREF='index.php?pag=profeencuestas&op=desactivar&codigo=<?php echo $fila['Código'];?>'><FONT COLOR="#ff0000"><B>Activada</B></FONT></A></FONT></TD>
			<?php } ?>
			<TD ALIGN=CENTER><FONT SIZE=2><A HREF='index.php?pag=profeencuestas&op=ver&codigo=<?php echo $fila['Código'];?>'><FONT COLOR="#ffff00">Ver</A></FONT></TD>
			<TD ALIGN=CENTER><FONT SIZE=2><A HREF='index.php?pag=profeencuestas&op=borrar&codigo=<?php echo $fila['Código'];?>' onClick="return confirm('¿Esta seguro de querer borrar la encuesta &quot;<?php echo $fila['Título'];?>&quot;, todas las preguntas,opciones y respuestas dadas por los alumnos definitivamente?')"><FONT COLOR="#ffff00">Borrar</A></FONT></TD>
			<TD ALIGN=CENTER><FONT SIZE=2><A HREF='index.php?pag=profeencuestas&op=editar&codigo=<?php echo $fila['Código'];?>'><FONT COLOR="#ffff00">Editar</A></FONT></TD>
			<TD><FONT SIZE=2><?php echo $fila['Título'];?></FONT></TD>
			<TD><FONT SIZE=2><?php echo fecha_europeo($fila['Fecha']);?></FONT></TD>
		</TR>
	<?php }; ?>
	</TBODY>
	</TABLE>
	<?php
	echo "<P ALIGN=CENTER>".mysqli_num_rows($result)." Encuestas.</P>";
	mysqli_free_result($result);

	?> <FORM NAME="CrearEncuesta" METHOD=POST ACTION="index.php?pag=profeencuestas&op=nueva">
		<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Crear una nueva"></P>
	</FORM> <?php
} elseif ($_GET['op']=="nueva" || $_GET['op']=="editar") {
	$formulario=0;
	if ($_GET['op']=="nueva") {
		echo "<H2 ALIGN=CENTER>Creando una encuesta:</H2>";
	} else {
		echo "<H2 ALIGN=CENTER>Editando una encuesta:</H2>";
	}
	if (!isset($_POST['Titulo'])) {
		$formulario=1;
	} elseif ($_POST['Titulo']=="") {
		echo "<H2 ALIGN=CENTER><FONT COLOR='#ff0000'>¡Error, introduzca un título!</FONT></H2>";
		$formulario=1;
	} elseif (!fecha_europea_valida($_POST['Fecha'])) {
		echo "<H2 ALIGN=CENTER><FONT COLOR='#ff0000'>¡Error, introduzca una fecha correcta!</FONT></H2>";
		$formulario=1;
	} else {
		?> <UL>
			<LI><DD><B>Título: </B><?php echo $_POST['Titulo'];?></DD>
			<LI><DD><B>Fecha: </B><?php echo $_POST['Fecha'];?></DD></UL>
		<?php
		if ($_GET['op']=="nueva") {
			$SQL="insert into encuestas (Título,Fecha,Asignatura) ";
			$SQL=$SQL."values ('".($_POST['Titulo'])."','";
			$SQL=$SQL.fecha_mysql($_POST['Fecha'])."',";
			$SQL=$SQL.$_SESSION['codasignatura'].")";
		} else {
			$SQL="UPDATE encuestas SET Título='";
			$SQL=$SQL.$_POST['Titulo'];
			$SQL=$SQL."',Fecha='".fecha_mysql($_POST['Fecha']);
			$SQL=$SQL."',Asignatura=".$_SESSION['codasignatura'];
			$SQL=$SQL." WHERE Código=".$_GET['codigo'];
		};
		if (!mysqli_query($conexion,$SQL)) {
			echo "<DL><DT>Estos datos no han podido ser almacenados.";
			echo "<UL><LI><DD>SQL: ".$SQL."</DD>";
			echo "<LI><DD>".mysqli_error()."</DD></DT></DL>";
		} else {
			echo "<DL><DT>Estos datos han sido almacenados.</DT></DL>";
			if ($_GET['op']=="editar") {
				?> <TABLE  WIDTH=100% BORDER=0>
					<THEAD>
						<TR>
							<TH>
								<FORM NAME="Encuesta" METHOD=POST ACTION="index.php?pag=profeencuestas">
									<P ALIGN=RIGHT><INPUT TYPE=SUBMIT VALUE="Volver a Encuestas"></P>
								</FORM>
							</TH>
							<TH>
								<FORM NAME="EditarPreguntas" METHOD=POST ACTION="index.php?pag=profepreguntas&encuesta=<?php echo $_GET['codigo'];?>">
									<P ALIGN=LEFT><INPUT TYPE=SUBMIT VALUE="Editar preguntas"></P>
								</FORM>
							</TH>
						</TR>
					</THEAD>
				</TABLE> <?php
			} else {
				?> <FORM NAME="Encuesta" METHOD=POST ACTION="index.php?pag=profeencuestas">
					<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Volver a Encuestas"></P>
				</FORM> <?php
			}
		};
	}
	if ($formulario) {
		if ($_GET['op']=="nueva") {
			?> <FORM NAME="CrearEncuesta" METHOD=POST ACTION="index.php?pag=profeencuestas&op=nueva">
				<P ALIGN=CENTER>Título: 	<TEXTAREA NAME="Titulo" ROWS=3 COLS=60><?php echo (isset($_POST['Titulo']))?$_POST['Titulo']:'';?></TEXTAREA></P>
				<P ALIGN=CENTER>Fecha: 	<INPUT TYPE=TEXT NAME="Fecha" SIZE=10 MAXLENGTH=10 VALUE="<?php echo (isset($_POST['Fecha']))?$_POST['Fecha']:date("d-m-Y");?>"></P>
				<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Enviar y Almacenar Datos"></P>
			</FORM> <?php
		} else {
			if (isset($_POST['Titulo'])) {
				?> <FORM NAME="CrearEncuesta" METHOD=POST ACTION="index.php?pag=profeencuestas&op=editar&codigo=<?php echo $_GET['codigo'];?>">
					<P ALIGN=CENTER>Título: 	<TEXTAREA NAME="Titulo" ROWS=3 COLS=60><?php echo (isset($_POST['Titulo']))?$_POST['Titulo']:'';?></TEXTAREA></P>
					<P ALIGN=CENTER>Fecha: 	<INPUT TYPE=TEXT NAME="Fecha" SIZE=10 MAXLENGTH=10 VALUE="<?php echo (isset($_POST['Fecha']))?$_POST['Fecha']:date("d-m-Y");?>"></P>
					<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Enviar y Almacenar Datos"></P>
				</FORM> <?php
			} else {
				$SQL="select * from encuestas where Código=".$_GET['codigo'];
				$result=mysqli_query($conexion,$SQL);
				$fila = mysqli_fetch_array($result)
				?> <FORM NAME="EditarEncuesta" METHOD=POST ACTION="index.php?pag=profeencuestas&op=editar&codigo=<?php echo $fila['Código'];?>">
					<P ALIGN=CENTER>Título: 	<TEXTAREA NAME="Titulo" ROWS=3 COLS=60><?php echo $fila['Título'];?></TEXTAREA></P>
					<P ALIGN=CENTER>Fecha: 	<INPUT TYPE=TEXT NAME="Fecha" SIZE=10 MAXLENGTH=10 VALUE="<?php echo fecha_europeo($fila['Fecha']);?>">
					<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Enviar y Almacenar Datos"></P>
				</FORM> <?php 
				mysqli_free_result($result);
			}
		}
	}
} elseif ($_GET['op']=="borrar"){
	$SQL="select * from encuestas where Código=".$_GET['codigo'];
	$result=mysqli_query($conexion,$SQL);
	$fila = mysqli_fetch_array($result);
	mysqli_free_result($result);
	?> <H2 ALIGN=CENTER>Borrando la encuesta:</H2>
		<UL>
			<LI><DD><B>Título: </B><?php echo $fila['Título'];?></DD>
			<LI><DD><B>Fecha: </B><?php echo fecha_europeo($fila['Fecha']);?></DD></UL>
	<DL><DT>Esta encuesta van a ser borrada y todos los datos relacionados.</DT></DL>
		<TABLE  WIDTH=100% BORDER=0>
			<THEAD>
				<TR>
					<TH>
						<FORM NAME="BorrarEncuesta" METHOD=POST ACTION="index.php?pag=profeencuestas&op=borrado&codigo=<?php echo $fila['Código'];?>">
							<P ALIGN=RIGHT><INPUT TYPE=SUBMIT VALUE="Borrar Encuesta"></P>
						</FORM>
					</TH>
					<TH>
						<FORM NAME="VolverEncuesta" METHOD=POST ACTION="index.php?pag=profeencuestas">
							<P ALIGN=LEFT><INPUT TYPE=SUBMIT VALUE="Volver a Encuesta"></P>
						</FORM>
					</TH>
				</TR>
			</THEAD>
		</TABLE>
		<?php
} elseif ($_GET['op']=="borrado"){
	$SQL="delete from encuestas where Código=".$_GET['codigo'];
	if (!mysqli_query($conexion,$SQL)) {
		echo "<DL><DT>Los datos no han podido ser borrados.(".mysqli_error().")</DT></DL>";
	} else {
		$SQL="delete from preguntas where Encuesta=".$_GET['codigo'];
		mysqli_query($conexion,$SQL);
		$SQL="delete from opciones where Encuesta=".$_GET['codigo'];
		mysqli_query($conexion,$SQL);
		$SQL="delete from respuestas where Encuesta=".$_GET['codigo'];
		mysqli_query($conexion,$SQL);
		$SQL="delete from accesos where Encuesta=".$_GET['codigo'];
		mysqli_query($conexion,$SQL);
		echo "<DL><DT>Los datos han sido borrados.</DT></DL>";
	};
} elseif ($_GET['op']=="activar" || $_GET['op']=="desactivar"){
	if ($_GET['op']=="activar") {
		echo "<H2 ALIGN=CENTER>Activando encuesta:</H2>";
	} else {
		echo "<H2 ALIGN=CENTER>Desactivando encuesta:</H2>";
	}
	$SQL="UPDATE encuestas SET Activa=";
	$SQL=$SQL.(($_GET['op']=="activar")?"'Si'":"'No'");
	$SQL=$SQL." WHERE Código=".$_GET['codigo'];
	if (!mysqli_query($conexion,$SQL)) {
		echo "<DL><DT>La operación no han podido ser realizada.<br>SQL:".$SQL."(".mysqli_error().")</DT></DL>";
	} else {
		?> <DL><DT>Operación realizada correctamente.</DT></DL>
		<FORM NAME="CrearEncuesta" METHOD=POST ACTION="index.php?pag=profeencuestas">
			<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Volver a Encuesta"></P>
		</FORM> <?php
	};
} elseif ($_GET['op']=="ver"){
	$SQL="select * from encuestas where Código=".$_GET['codigo'];
	$encuestas=mysqli_query($conexion,$SQL);
	$encuesta = mysqli_fetch_array($encuestas);
	$SQL="select DISTINCT Alumno from respuestas where Encuesta=".$_GET['codigo'];
	$encuestados=mysqli_query($conexion,$SQL);
	$N_encuestados=mysqli_num_rows($encuestados);
	mysqli_free_result($encuestados);
	echo "<H1 ALIGN=CENTER>".nl2br(htmlspecialchars($encuesta['Título']))."</H1>";
	$SQL="select * from preguntas where Encuesta=".$_GET['codigo']."";
	$N_preguntas=0;
	if ($preguntas=mysqli_query($conexion,$SQL)) {
		$N_preguntas=mysqli_num_rows($preguntas);
		while($pregunta = mysqli_fetch_array($preguntas)) {
			echo "<DL><DT><FONT SIZE=5>".nl2br(htmlspecialchars($pregunta['Enunciado']))."</FONT></DT></DL>";
			if ($pregunta['Test']=="Test") {
				$SQL="select * from opciones where Pregunta=".$pregunta['Código']."";
				if ($opciones=mysqli_query($conexion,$SQL)) {
					$valor=1;
					echo "<UL><DD><FONT COLOR='#ffffff'>(";
					$SQL="select datospersonales.Nombre AS Nombre,datospersonales.Apellidos AS Apellidos from respuestas, datospersonales where respuestas.Alumno=datospersonales.Código and respuestas.Pregunta=".$pregunta['Código']." AND respuestas.Test=0 order by Apellidos, Nombre";
					if ($respuestas=mysqli_query($conexion,$SQL)) {
						if ($respuesta = mysqli_fetch_array($respuestas)) {
							$alumnos=$respuesta['Apellidos'].", ".$respuesta['Nombre'];
							while($respuesta = mysqli_fetch_array($respuestas)) {
								$alumnos=$alumnos."; ".$respuesta['Apellidos'].", ".$respuesta['Nombre'];
//								echo $;
							}
						} else {$alumnos="";}
						echo '<B title="'.$alumnos.'">'.mysqli_num_rows($respuestas).'</B>';
						mysqli_free_result($respuestas);
					};
					echo ")</FONT>No respondo.</DD>";
					while($opcion = mysqli_fetch_array($opciones)) {
						echo "<DD><FONT COLOR='#ffffff'>(";
						$SQL="select datospersonales.Nombre AS Nombre,datospersonales.Apellidos AS Apellidos from respuestas, datospersonales where respuestas.Alumno=datospersonales.Código and respuestas.Pregunta=".$pregunta['Código']." AND respuestas.Test=".$opcion['Código']. " order by Apellidos, Nombre";
						if ($respuestas=mysqli_query($conexion,$SQL)) {
							if ($respuesta = mysqli_fetch_array($respuestas)) {
								$alumnos=$respuesta['Apellidos'].", ".$respuesta['Nombre'];
								while($respuesta = mysqli_fetch_array($respuestas)) {
									$alumnos=$alumnos."; ".$respuesta['Apellidos'].", ".$respuesta['Nombre'];
//									echo $;
								}
							} else {$alumnos="";}
							echo '<B title="'.$alumnos.'">'.mysqli_num_rows($respuestas).'</B>';
							mysqli_free_result($respuestas);
						};
						echo ")</FONT>";
//						$SQL="select * from preguntas where Código=".$pregunta['Código'];
//						$validas=mysqli_query($conexion,$SQL);
//						$valida=mysqli_fetch_array($validas);
						echo (($pregunta['correcta']==$opcion['Código'])?"<B>":"") . nl2br(htmlspecialchars($opcion['Enunciado'])) . (($pregunta['correcta']==$opcion['Código'])?"</B>":"") . "</DD>";
//						mysqli_free_result($validas);
//						$valor=$valor+1;
					};
					echo "</UL>";
					mysqli_free_result($opciones);
				}
			} else {

				$SQL="SELECT COUNT(*) as n FROM respuestas WHERE encuesta=" . $_GET['codigo']. " AND pregunta =". $pregunta['Código'] . " AND Texto IS NULL";
				$npbs=mysqli_query($conexion,$SQL); 
				$npb=mysqli_fetch_array($npbs);
				echo "<UL><DD>" . $npb['n'] . " de los que respondieron lo hicieron en blanco.</DD></UL>";
				mysqli_free_result($npbs);
			}
		}
		mysqli_free_result($preguntas);
	}; ?>
	<?php
	echo "<P ALIGN=CENTER>".$N_preguntas." Preguntas. ".$N_encuestados." Encuestados</P>";
	mysqli_free_result($encuestas);
	?>
	<TABLE  WIDTH=100% BORDER=0>
		<THEAD>
			<TR>
				<TH>
	<FORM NAME="EncuestaVerEnvios" METHOD=POST ACTION="index.php?pag=profeencuestas&op=veraccesos&encuesta=<?php echo $_GET['codigo'];?>">
		<INPUT TYPE=SUBMIT VALUE="Envios a Encuesta">
	</FORM> 
				</TH>
				<TH>
	<FORM NAME="GeneraInforme" METHOD=POST ACTION="index.php?pag=profeencuestas&op=informe&encuesta=<?php echo $_GET['codigo'];?>">
		<INPUT TYPE=SUBMIT VALUE="Genera Informe">
	</FORM> 
 				</TH>
				<TH>
	<FORM NAME="EncuestaVerAlumno" METHOD=POST ACTION="index.php?pag=profeencuestas&op=veralumno&encuesta=<?php echo $_GET['codigo'];?>">
		<INPUT TYPE=SUBMIT VALUE="Alumno en concreto">
	</FORM> 
 				</TH>
				</TR>
			</THEAD>
		</TABLE>
	<?php
} elseif ($_GET['op']=="informe"){
	$SQL="select * from encuestas where Código=".$_GET['encuesta'];
	$encuestas=mysqli_query($conexion,$SQL);
	$encuesta = mysqli_fetch_array($encuestas);
	mysqli_free_result($encuestas);
	$SQL="select Código,DNI,Apellidos,Nombre from datospersonales,cursa where datospersonales.Código=cursa.Alumno and cursa.Asignatura=".$_SESSION['codasignatura']." and cursa.Año='".$_SESSION['anno']."' order by Apellidos,Nombre";
	if ($alumnos=mysqli_query($conexion,$SQL)){
		$nalumnos=mysqli_num_rows($alumnos);
		include ('./pdf/class.ezpdf.php');
		$pdf = new Cezpdf();
		$ialumno=1;
		$pdf->ezStartPageNumbers(500,50,8,'right',iconv("UTF-8","ISO-8859-1",'Página {PAGENUM} de {TOTALPAGENUM}'),1);
		while($alumno = mysqli_fetch_array($alumnos)) {
			$pdf->selectFont('./pdf/fonts/Helvetica.afm');
			$pdf->ezText(iconv("UTF-8","ISO-8859-1",'('.$_SESSION['anno'].') '.$_SESSION['nivel'].'º'.$_SESSION['ensenanza'].' - '.$_SESSION['asignatura']),14);
			$pdf->ezText(iconv("UTF-8","ISO-8859-1",$encuesta['Título']),14);
			$pdf->ezText("",8);
			$pdf->ezText(iconv("UTF-8","ISO-8859-1","DNI: " . $alumno['DNI'] . "       Fecha: " . date("d-m-Y") . "       Alumno: " . $alumno['Apellidos'] . ", " . $alumno['Nombre']),12);
			$pdf->selectFont('./pdf/fonts/Times-Roman.afm');
			$SQL="select * from preguntas where Encuesta=".$_GET['encuesta']."";
			if ($preguntas=mysqli_query($conexion,$SQL)) {
				while($pregunta = mysqli_fetch_array($preguntas)) {
					$pdf->ezText("",8);
					$pdf->ezText(iconv("UTF-8","ISO-8859-1","Pregunta: ".$pregunta['Enunciado']),8);
					$SQL="select * from respuestas where Pregunta=".$pregunta['Código']." AND Alumno=".$alumno['Código']." AND Encuesta=".$_GET['encuesta'];
					$respuestas= mysqli_query($conexion,$SQL);
					$respuesta = mysqli_fetch_array($respuestas);
					if (mysqli_num_rows($respuestas)>0) $hizo=1; else $hizo=0;
					mysqli_free_result($respuestas);
					if ($pregunta['Test']=='Test') {
						$SQL="select * from opciones where Pregunta=".$pregunta['Código']."";
						if ($opciones=mysqli_query($conexion,$SQL)) {
							$pdf->ezText(iconv("UTF-8","ISO-8859-1","    " . (($hizo)?(($respuesta['Test']=='0')?'X ':'    '):'    ') . "No respondo."),8);
							$valor=1;
							while($opcion = mysqli_fetch_array($opciones)) {
								$pdf->ezText(iconv("UTF-8","ISO-8859-1","    " . (($hizo)?(($respuesta['Test']==$opcion['Código'])?"X ":"    "):"    ") . $opcion['Enunciado']),8);
								$valor=$valor+1;
							};
							mysqli_free_result($opciones);
						}
					} else {
						$pdf->selectFont('./pdf/fonts/Times-Bold.afm');
						$pdf->ezText("",8);
						$pdf->ezText(iconv("UTF-8","ISO-8859-1",(($hizo)?$respuesta['Texto']:"")),8);
						$pdf->ezText("",8);
						$pdf->selectFont('./pdf/fonts/Times-Roman.afm');
					}
				}
				mysqli_free_result($preguntas);
				$pdf->ezText("",10);
				$pdf->ezText("",10);
				$pdf->ezText("",10);
				$pdf->ezText("",10);
				$pdf->ezText(iconv("UTF-8","ISO-8859-1","                                                                         Firmado: " . $alumno['Apellidos'] . ", " . $alumno['Nombre']),10);
				if ($ialumno<$nalumnos) {
					$pdf->ezNewPage();
					$ialumno++;
				};
			}; 
		};
		mysqli_free_result($alumnos);
		$pdf->ezPRVTaddPageNumbers();
		$pdfcode=$pdf->ezOutput();
		$ficheroPDF='/var/www/pruebas/http/archivos/' . date("Y_m_d_") . $_SESSION['nivel'] ."o". $_SESSION['ensenanza'] ."_". $_SESSION['asignatura'] ."_". substr($encuesta['Título'],0,100) . '.pdf';
		$fp=fopen($ficheroPDF,'wb');
		echo "</br>".$ficheroPDF."</br>";
		echo $fp."</br>";
		fwrite($fp,$pdfcode);
		fclose($fp);
	};
	?>
	<FORM NAME='ViendoEncuesta' METHOD=POST ACTION="index.php?pag=profeencuestas&op=veralumno&encuesta=<?php echo $_GET['encuesta'];?>">
		<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Volver"></P>
	</FORM>
	<?php
	echo "<P ALIGN=CENTER>".$nalumnos." Alumnos generados en '" . date("d_m_Y_") . $_SESSION['nivel'] ."o". $_SESSION['ensenanza'] ."_". $_SESSION['asignatura'] ."_". substr($encuesta['Título'],0,100) . ".pdf'" . ".</P>";
	echo "<P ALIGN=CENTER> Almacenado en Archivos</P>";

} elseif ($_GET['op']=="veraccesos"){
	$SQL="select * from encuestas where Código=".$_GET['encuesta'];
	$encuestas=mysqli_query($conexion,$SQL);
	$encuesta = mysqli_fetch_array($encuestas);
	echo "<H1 ALIGN=CENTER>".$encuesta['Título']."</H1>";
	mysqli_free_result($encuestas);
	$SQL="SELECT Apellidos AS apellidos, Nombre AS nombre, IP AS ip, instante AS momento FROM datospersonales, accesos WHERE accesos.Alumno = datospersonales.Código AND accesos.Encuesta =".$_GET['encuesta'] . " ORDER BY apellidos,nombre";
	$result=mysqli_query($conexion,$SQL);
	?>
	<TABLE ALIGN=CENTER BORDER=1 CELLSPACING=1 CELLPADDING=1>
	<THEAD>
		<TR>
			<TH><FONT SIZE=2>Nombre</FONT></TH>
			<TH><FONT SIZE=2>Apellidos</FONT></TH>
			<TH><FONT SIZE=2>IP</FONT></TH>
			<TH><FONT SIZE=2>Instante</FONT></TH>
		</TR>
	</THEAD>
	<TBODY>
	<?php $alumnos=mysqli_num_rows($result); while($fila = mysqli_fetch_array($result)) {?>
		<TR>
			<TD><FONT SIZE=2><?php echo $fila['nombre'];?></FONT></TD>
			<TD><FONT SIZE=2><?php echo $fila['apellidos'];?></FONT></TD>
			<TD><FONT SIZE=2><?php echo $fila['ip'];?></FONT></TD>
			<TD><FONT SIZE=2><?php echo $fila['momento'];?></FONT></TD>
		</TR>
	<?php }; ?>
	</TBODY>
	</TABLE>
	<?php
	echo "<P ALIGN=CENTER>". $alumnos ." Alumn@s.</P>";
	mysqli_free_result($result);
	?> <FORM NAME="EncuestaVer" METHOD=POST ACTION="index.php?pag=profeencuestas&op=ver&codigo=<?php echo $_GET['encuesta'];?>">
		<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Volver a Ver Encuesta"></P>
	</FORM> <?php
} elseif ($_GET['op']=="veralumno"){
	if (!isset($_GET['alumno'])) {
		$SQL="select * from encuestas where Código=".$_GET['encuesta'];
		$encuestas=mysqli_query($conexion,$SQL);
		$encuesta = mysqli_fetch_array($encuestas);
		echo "<H1 ALIGN=CENTER>".'('.$_SESSION['anno'].') '.$_SESSION['nivel'].'º'.$_SESSION['ensenanza'].' - '.$_SESSION['asignatura']."</H1>";
		echo "<H1 ALIGN=CENTER>".$encuesta['Título']."</H1>";
		mysqli_free_result($encuestas);
		$SQL="select DISTINCT Alumno,Nombre,Apellidos,DNI from datospersonales,respuestas where datospersonales.Código=respuestas.Alumno AND Encuesta=".$_GET['encuesta']." ORDER BY datospersonales.Apellidos, datospersonales.Nombre";
		$result=mysqli_query($conexion,$SQL);
		?>
		<TABLE ALIGN=CENTER BORDER=1 CELLSPACING=1 CELLPADDING=1>
		<THEAD>
			<TR>
				<TH><FONT SIZE=2>Ver</FONT></TH>
				<TH><FONT SIZE=2>Nombre</FONT></TH>
				<TH><FONT SIZE=2>Apellidos</FONT></TH>
				<TH><FONT SIZE=2>Bien</FONT></TH>
				<TH><FONT SIZE=2>Mal</FONT></TH>
				<TH><FONT SIZE=2>Texto</FONT></TH>
				<TH><FONT SIZE=2>Nota</FONT></TH>
			</TR>
		</THEAD>
		<TBODY>
			<?php $alumnos=mysqli_num_rows($result); while($fila = mysqli_fetch_array($result)) {?>
			<TR>
				<TD><FONT SIZE=2><A HREF="index.php?pag=profeencuestas&op=veralumno&encuesta=<?php echo $_GET['encuesta'];?>&alumno=<?php echo $fila['Alumno'];?>&nombre=<?php echo $fila['Nombre'];?>">Ver<A/></FONT></TD>
				<TD><FONT SIZE=2><?php echo $fila['Nombre'];?></FONT></TD>
				<TD><FONT SIZE=2><?php echo $fila['Apellidos'];?></FONT></TD>
				<?php $SQL="SELECT COUNT(*) as bien FROM preguntas, respuestas WHERE respuestas.encuesta=" . $_GET['encuesta'] . " and preguntas.encuesta=" . $_GET['encuesta'] . " and respuestas.Alumno =" . $fila['Alumno'] . " AND preguntas.Código = respuestas.pregunta AND preguntas.correcta = respuestas.Test AND preguntas.Test='Test'";
				$bienes=mysqli_query($conexion,$SQL); 
				$bien=mysqli_fetch_array($bienes);?>
				<TD><FONT SIZE=2><?php echo $bien['bien']; ?></FONT></TD>
				<?php $pb=$bien['bien']*1; mysqli_free_result($bienes); ?>
				<?php $SQL="SELECT COUNT(*) as mal FROM preguntas, respuestas WHERE respuestas.encuesta=" . $_GET['encuesta'] . " and preguntas.encuesta=" . $_GET['encuesta'] . " and respuestas.Alumno =" . $fila['Alumno'] . " AND preguntas.Código = respuestas.pregunta AND preguntas.correcta != respuestas.Test  AND respuestas.Test != 0 AND preguntas.Test='Test'";
				$males=mysqli_query($conexion,$SQL); 
				$mal=mysqli_fetch_array($males);?>
				<TD><FONT SIZE=2><?php echo $mal['mal']; ?></FONT></TD>
				<?php $pm=$mal['mal']*1;mysqli_free_result($males); ?>

				<?php $SQL="SELECT SUM(TextoMax) as s FROM preguntas WHERE preguntas.encuesta=" . $_GET['encuesta']. " AND preguntas.Test = 'Texto'";
				$tms=mysqli_query($conexion,$SQL);
				echo mysqli_error($tms);
				$tm=mysqli_fetch_array($tms);
				$etm=$tm['s'];
				mysqli_free_result($tms);
				$etn=0;
				if ($etm>0) {
				    $SQL="SELECT SUM(respuestas.TextoPuntos) as s FROM respuestas, preguntas WHERE respuestas.encuesta=" . $_GET['encuesta'] . " and respuestas.Alumno =" . $fila['Alumno'] . " AND preguntas.Código = respuestas.pregunta AND preguntas.Test='Texto'";
				    $tns=mysqli_query($conexion,$SQL); 
				    $tn=mysqli_fetch_array($tns);
				    $etn=$tn['s'];?>
				    <TD><FONT SIZE=2><?php echo str_replace(".",",",$etn); ?></FONT></TD>
				    <?php mysqli_free_result($tns);
				} else { echo "<TD><FONT SIZE=2>No</FONT></TD>";}
				$SQL="SELECT COUNT(*) as n FROM preguntas WHERE preguntas.encuesta=" . $_GET['encuesta']. " AND preguntas.Test = 'Test'";
				$nps=mysqli_query($conexion,$SQL); 
				$np=mysqli_fetch_array($nps);
				$nota=0;
				$nota=($pb*((10-$etm)/$np['n']) - $pm*((10-$etm)/(2*$np['n'])))+$etn;
				?>
				<TD><FONT SIZE=2><?php echo (($nota>=5)?"<B>":"") . str_replace(".",",",$nota) . (($nota>=5)?"</B>":""); ?></FONT></TD>
				<?php mysqli_free_result($nps); ?>

			</TR>
		<?php }; ?>
		</TBODY>
		</TABLE>
		<?php
		echo "<P ALIGN=CENTER>". $alumnos ." Alumn@s.</P>";
		mysqli_free_result($result);
		?> <FORM NAME="EncuestaVer" METHOD=POST ACTION="index.php?pag=profeencuestas&op=ver&codigo=<?php echo $_GET['encuesta'];?>">
			<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Volver a Ver Encuesta"></P>
		</FORM> <?php
	} else {
		if (isset($_POST['pregunta']) && isset($_POST['nota'])) {
			$SQL="select * from respuestas where Alumno=".$_GET['alumno']." AND Encuesta=".$_GET['encuesta']." AND Pregunta=".$_POST['pregunta'] ;
			$respuestas=mysqli_query($conexion,$SQL);
			//echo "había = ".mysqli_num_rows($respuestas);
			if (mysqli_num_rows($respuestas)>0) {
				$SQL="UPDATE respuestas SET TextoPuntos=".str_replace(",",".",$_POST['nota']);
				$SQL=$SQL." WHERE Alumno=".$_GET['alumno']." AND Encuesta=".$_GET['encuesta']." AND Pregunta=".$_POST['pregunta'] ;
				if (!mysqli_query($conexion,$SQL)) {
					echo "Error: p_encuestas actualiza puntos texto - ".$SQL.mysqli_error();
				}
			} else {
				$SQL="INSERT INTO respuestas (TextoPuntos,Alumno,Encuesta,Pregunta) VALUES (".str_replace(",",".",$_POST['nota']).",".$_GET['alumno'].",".$_GET['encuesta'].",".$_POST['pregunta'].");";
				//echo $SQL;
				if (!mysqli_query($conexion,$SQL)) {
					echo "Error: p_encuestas insertar puntos texto - ".$SQL.mysqli_error();
				}
			}
		}
		$SQL="select * from encuestas where Código=".$_GET['encuesta'];
		$encuestas=mysqli_query($conexion,$SQL);
		$encuesta = mysqli_fetch_array($encuestas);

		?>
		<H1 ALIGN=CENTER><?php echo $encuesta['Título']."(".$_GET['nombre'].")";?></H1>
		<FORM NAME='ViendoEncuesta' METHOD=POST ACTION="index.php?pag=profeencuestas&op=veralumno&encuesta=<?php echo $_GET['encuesta'];?>">
			<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Volver"></P>
		</FORM>
		<?php 
		$SQL="select * from respuestas where Encuesta=".$_GET['encuesta']." AND Alumno=".$_GET['alumno'];
		$result=mysqli_query($conexion,$SQL);
		if (mysqli_num_rows($result)>0) $existe=1; else $existe=0;
		mysqli_free_result($result);
		$SQL="select * from preguntas where Encuesta=".$_GET['encuesta']."";
		if ($preguntas=mysqli_query($conexion,$SQL)) {
			while($pregunta = mysqli_fetch_array($preguntas)) {
				if ($existe) {
					$SQL="select * from respuestas where Pregunta=".$pregunta['Código']." AND Alumno=".$_GET['alumno']." AND Encuesta=".$_GET['encuesta'];
					$respuestas=mysqli_query($conexion,$SQL);
					$respuesta = mysqli_fetch_array($respuestas);
					mysqli_free_result($respuestas);
					$PreguntaYaEnviada=1;
				} else $PreguntaYaEnviada=0;
				echo "<DL><DT><FONT SIZE=5>".nl2br(htmlspecialchars($pregunta['Enunciado']))."</FONT></DT></DL>";
				if ($pregunta['Test']=='Test') {
					$SQL="select * from opciones where Pregunta=".$pregunta['Código']."";
					if ($opciones=mysqli_query($conexion,$SQL)) {
						echo "<UL>";
						$valor=1;
						echo "<DD><INPUT TYPE=RADIO NAME='".$pregunta['Código']."' DISABLED VALUE='0'";
						echo (($PreguntaYaEnviada)?(($respuesta['Test']=="0")?" CHECKED":""):" CHECKED").">";
						echo "<FONT COLOR='#ffffff'>No respondo.</FONT></DD>";
						while($opcion = mysqli_fetch_array($opciones)) {
//							echo $respuesta['Test']."==".$opcion['Código'];
							echo "<DD><INPUT TYPE=RADIO NAME='".nl2br(htmlspecialchars($pregunta['Código']))."' DISABLED VALUE='".$valor."'";
							echo (($PreguntaYaEnviada)?(($respuesta['Test']==$opcion['Código'])?" CHECKED":""):"");
							echo ">".(($pregunta['correcta']==$opcion['Código'])?"<B>":"") . "<FONT COLOR='#ffffff'>".nl2br(htmlspecialchars($opcion['Enunciado']))."</FONT></DD>" . (($pregunta['correcta']==$opcion['Código'])?"</B>":"") . "</DD>";
							$valor=$valor+1;
						};
						echo "</UL>";
						mysqli_free_result($opciones);
					}
				} else {
					echo "<P ALIGN=CENTER><TEXTAREA NAME='".$pregunta['Código']."' READONLY ROWS=5 COLS=60>\n ".(($PreguntaYaEnviada)?htmlspecialchars($respuesta['Texto']):"")."\n </TEXTAREA></P>";
					$SQL="select * from respuestas WHERE Encuesta=".$_GET['encuesta']." AND Pregunta=".$pregunta['Código']." AND  Alumno=".$_GET['alumno'];
					$notas=mysqli_query($conexion,$SQL);
					$nota = mysqli_fetch_array($notas);
					$n=$nota['TextoPuntos'];
					mysqli_free_result($notas);
					?>
					<FORM NAME="Corregir" METHOD=POST ACTION="index.php?pag=profeencuestas&op=veralumno&encuesta=<?php echo $_GET['encuesta'];?>&alumno=<?php echo $_GET['alumno'];?>&nombre=<?php echo rawurlencode($_GET['nombre']);?>">
						<P ALIGN=CENTER><INPUT TYPE=HIDDEN DISABLE NAME="pregunta" VALUE="<?php echo $pregunta['Código'];?>">
						<INPUT TYPE=TEXT NAME="nota" SIZE=2 VALUE="<?php echo str_replace(".",",",$n);?>">
						<INPUT TYPE=SUBMIT VALUE="Modificar">
						</P>
					</FORM>
					<?php
				}
			}
			mysqli_free_result($preguntas);
		}; ?>
		<FORM NAME='ViendoEncuesta' METHOD=POST ACTION="index.php?pag=profeencuestas&op=veralumno&encuesta=<?php echo $_GET['encuesta'];?>">
			<P ALIGN=CENTER><INPUT TYPE=SUBMIT VALUE="Volver"></P>
		</FORM>
		<?php
		echo "<P ALIGN=CENTER>".mysqli_num_rows($encuestas)." Encuestas.</P>";
		mysqli_free_result($encuestas);
	}
}
mysqli_close($conexion);
?>

