/*
 * Decompiled with CFR 0.152.
 */
package gota;

import gota.Lang;
import gota.Monitor;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Gota
implements SingleInstanceListener {
    public static final boolean DEBUG = true;
    public static final boolean DEBUG_GUI = false;
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "GOTA" + System.getProperty("file.separator") + "download" + System.getProperty("file.separator");
    public static final String MONITOR_DIR = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "GOTA" + System.getProperty("file.separator");
    public static TrayIcon trayIcon;
    public static Lang lang;
    public static String arg;
    public static String version;
    public static String productName;
    public static String sid;
    public static String securityToken;
    public Monitor monitor;

    public void newActivation(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < args.length; ++ii) {
            sb.append("'").append(args[ii]).append("' ");
        }
        String message = "Got new args: " + sb.toString();
        Gota.info(message);
        String gofUrl = "";
        if (args.length > 0) {
            gofUrl = args[0];
        }
        if (args.length > 1) {
            securityToken = args[1];
        }
        if (args.length > 2) {
            sid = args[2];
        }
        if (gofUrl.length() > 0) {
            this.monitor.monitorGOF(Gota.appendSecurityToken(gofUrl));
        }
    }

    public static void deleteDirectory(File path) throws IOException {
        if (path.isDirectory()) {
            for (File child : path.listFiles()) {
                Gota.deleteDirectory(child);
            }
        }
        if (!path.delete()) {
            throw new IOException("Could not delete " + path);
        }
    }

    public static String appendSecurityToken(String url) {
        return url + "&security_token=" + securityToken;
    }

    public Gota(String gofUrl, String securityToken, String sid, String lang, String trayIconUrl, String productName) {
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener((SingleInstanceListener)this);
        }
        catch (UnavailableServiceException use) {
            use.printStackTrace();
            Gota.info("Instance already running");
            System.exit(-1);
        }
        Gota.securityToken = securityToken;
        Gota.sid = sid;
        Gota.productName = productName;
        Gota.lang = new Lang();
        Gota.lang.setLang(lang);
        this.setLookAndFeel();
        this.initTray(trayIconUrl);
        this.monitor = new Monitor();
        if (gofUrl.length() > 0) {
            this.monitor.monitorGOF(Gota.appendSecurityToken(gofUrl));
        }
    }

    private void initTray(String trayIconUrl) {
        try {
            Image image;
            URL imageUrl;
            SystemTray tray = SystemTray.getSystemTray();
            if (trayIconUrl.equals("default")) {
                imageUrl = System.getProperty("os.name").equals("Linux") ? this.getClass().getResource("/images/GO22x22.gif") : this.getClass().getResource("/images/GO16x16.gif");
                image = Toolkit.getDefaultToolkit().getImage(imageUrl);
            } else {
                imageUrl = new URL(trayIconUrl);
                image = ImageIO.read(imageUrl);
            }
            PopupMenu popup = new PopupMenu();
            MenuItem infoItem = new MenuItem(lang.getString("btnInfo"));
            infoItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String copyright = "Group-Office".equals(productName) ? "Group-Office Transfer Agent " + version + " - Copyright Intermesh BV 2003 - 2018" : productName + " Transfer Agent " + version;
                    JOptionPane.showMessageDialog(null, copyright);
                }
            });
            popup.add(infoItem);
            popup.addSeparator();
            MenuItem defaultItem = new MenuItem(lang.getString("btnExit"));
            defaultItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Gota.deleteDirectory(new File(MONITOR_DIR));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Gota.info("Exiting...");
                    SystemTray.getSystemTray().remove(trayIcon);
                    System.exit(0);
                }
            });
            popup.add(defaultItem);
            trayIcon = new TrayIcon(image, productName + " Transfer Agent", popup);
            tray.add(trayIcon);
            trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Gota.this.monitor.lockFile();
                }
            });
        }
        catch (UnsupportedOperationException e) {
            Gota.error("TrayIcon not supported.");
        }
        catch (AWTException e) {
            Gota.error("TrayIcon could not be added.");
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            Gota.error("TrayIcon image could not be created");
            e.printStackTrace();
        }
        catch (IOException e) {
            Gota.error("TrayIcon image could not be created");
            e.printStackTrace();
        }
    }

    private void setLookAndFeel() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (ClassNotFoundException e) {
            Gota.error("Couldn't find class for specified look and feel:" + lookAndFeel);
            Gota.error("Did you include the L&F library in the class path?");
            Gota.error("Using the default look and feel.");
        }
        catch (UnsupportedLookAndFeelException e) {
            Gota.error("Can't use the specified look and feel (" + lookAndFeel + ") on this platform.");
            Gota.error("Using the default look and feel.");
        }
        catch (Exception e) {
            Gota.error("Couldn't get specified look and feel (" + lookAndFeel + "), for some reason.");
            Gota.error("Using the default look and feel.");
            e.printStackTrace();
        }
    }

    public static void info(String msg) {
        System.out.println(msg);
    }

    public static void error(String msg) {
        System.err.println(msg);
        JOptionPane.showMessageDialog(null, msg, "attention", 0);
    }

    public static void main(String[] args) throws IOException {
        String lang = "en";
        String securityToken = "";
        String sid = "";
        String url = "";
        String trayIconUrl = "default";
        String productName = "";
        if (args.length > 0) {
            url = args[0];
        }
        if (args.length > 1) {
            securityToken = args[1];
        }
        if (args.length > 2) {
            sid = args[2];
        }
        if (args.length > 3) {
            lang = args[3];
        }
        if (args.length > 4) {
            trayIconUrl = args[4];
        }
        if (args.length > 5) {
            productName = args[5];
        }
        Gota gota = new Gota(url, securityToken, sid, lang, trayIconUrl, productName);
    }

    static {
        version = "1.1.16";
        productName = "Group-Office";
    }
}

