Ext.define('go.modules.business.business.EmployeeCombo', {
	extend: go.form.ComboBoxReset,

	fieldLabel: t("Employee"),
	hiddenName: 'employeeId',
	tpl: new Ext.XTemplate(
		'<tpl for=".">',
		'<div class="x-combo-list-item"><div class="user">\
			 <tpl if="!values.avatarId"><div class="avatar"></div></tpl>\\n\
			 <tpl if="values.avatarId"><div class="avatar" style="background-image:url({[go.Jmap.downloadUrl(values.avatarId)]})"></div></tpl>\
			 <div class="wrap">\
				 <div>{values.displayName}</div><small>{values.username}</small>\
			 </div>\
		 </div></div>',
		'</tpl>'
	),
	emptyText: t("Please select..."),
	displayField : 'displayName',
	valueField: 'id',
	pageSize: 50,
	triggerAction: 'all',
	editable: true,
	selectOnFocus: true,
	forceSelection: true,
	allowBlank: false,
	initComponent: function() {
		this.store = new go.data.Store({
			fields: ['id', 'displayName', 'username', 'avatarId'],
			entityStore: "UserDisplay",
			filters: {isEmployee: {isEmployee: true}, enabled: {showDisabled: false}},
			sortInfo: {field: 'displayName', direction: 'ASC'}
		});
		this.callParent();
	}
});