Ext.define('go.modules.business.business.EmployeeGrid', {
	extend: go.grid.GridPanel,

	initComponent: function () {

		this.store = new go.data.Store({
			fields: [
				'id',
				{name: 'agreements', type: 'relation'},
				{name: 'user', type: 'relation'},
				{name: 'timeClosedUntil', type: 'date'},
				{name: 'quitAt', type: 'date'},
				{name: 'hourlyRevenue', type: 'float'}
			],
			sortInfo :{field: "id", direction: "DESC"},
			entityStore: "Employee"
		});

		Ext.apply(this, {
			columns: [{
				id: 'id',
				header: t('Number'),
				width: dp(80),
				sortable: true,
				dataIndex: 'id',
				align: "right"
			},{
				header: t('Name'),
				dataIndex: 'user',
				renderer: function(v) {
					return v ? v.displayName : '-';
				}
			},{
				header: t('Agreement'),
				sortable: true,
				dataIndex: 'agreement',
				width: dp(200),
				renderer: function (v) {
					return v ? v.hourlyCost : "-";
				}
			},{
				header: t('Status'),
				width: dp(160),
				sortable: false,
				dataIndex: 'quitAt',
				renderer: function(v, meta, data) {
					if(!v){
						return t('Active');
					}
					if(new Date(v) < new Date()) {
						return t('Quit')
					}
					return t('Will quit at') +' '+ (new Date(v));
				}
			},{
				xtype: "datecolumn",
				header: t('Hours approved until'),
				sortable: true,
				dataIndex: 'timeClosedUntil',
				hidden: true
			},{
				xtype: "numbercolumn",
				header: t('Hourly revenue'),
				sortable: true,
				dataIndex: 'hourlyRevenue',
				hidden: true
			}].concat(go.customfields.CustomFields.getColumns("Employee")),
			viewConfig: {
				emptyText: '<i>description</i><p>' + t("No items to display") + '</p>'
			}
		});
		
		this.callParent();
	}
});

