Ext.define('go.modules.business.business.UserEmployeePanel', {
	extend: Ext.Panel,

	isAllowed: function() {
		return go.Modules.get("business","business").userRights.mayManageEmployees
	},

	title: t('Employee'),
	iconCls: 'ic-business',

	layout: "form",
	autoScroll: true,
	index: 1,
	initComponent: function () {

		this.items = [
			this.leftSide(),
			this.rightSide()
		];

		this.callParent();

		this.agreements.on('afterrender', function() {
			this.agreements.store.load();
		}, this);

		this.managersFieldGrid.addCombo.store.setFilter('isEmployee', {isEmployee: true});
		this.externalRatePerActivity.addCombo.store.setFilter('billableOnly', {billable: true});
	},

	leftSide: function() {
		return {xtype:'container', items:[
			{xtype: 'container', layout: 'column', defaults: {columnWidth: .5},items:[{xtype:'fieldset', title: t('Employee'),labelWidth: 130,items:[
				new go.form.ComboBox({
					fieldLabel: t("Business"),
					anchor: '100%',
					hiddenName: 'employee.businessId',
					emptyText: t("Please select..."),
					pageSize: 50,
					valueField: 'id',
					displayField: 'name',
					triggerAction: 'all',
					selectOnFocus: true,
					forceSelection: true,
					store: new go.data.Store({
						fields: ['name','id'],
						sort: [{property: "name"}],
						entityStore: "Business"
					})
				}),{
					xtype: 'datefield',
					name: 'employee.timeClosedUntil',
					fieldLabel: t("Timesheet closed until"),
					anchor: '100%'
				},{
					xtype: 'datefield',
					name: 'employee.quitAt',
					fieldLabel: t("Quit employement at"),
					emptyText: t('Blank if still employed'),
					anchor: '100%'
				}]},
				this.managersFieldGrid = new go.form.ArrayFieldGrid({
					properties: ['managerId', 'notified'],
					defaultValues: {notified: true},
					tbtitle: t('Managers'),
					name: "employee.managers",
					idField: "managerId",
					displayField: "displayName",
					entityStore: "UserDisplay",
					extraColumns: [{
						dataIndex: 'notified',
						header: t('Receive email'),
						renderer: go.grid.ColumnRenderers.yesNo,
						editor: new Ext.form.Checkbox()
					}],
					extraFields: ['notified']
				})
			]},
			this.agreements = new go.modules.business.business.AgreementGrid()
		]}
	},

	rightSide: function() {
		return {xtype:'container', layout: 'column',items:[
			this.rateFieldSet = new Ext.form.FieldSet({title: t('Rates'),columnWidth: .4,items:[{
					xtype: 'numberfield',
					name: 'employee.hourlyCosts',
					fieldLabel: t("Internal fee"),
					width: 80,
					prefix: go.User.currency,
					allowBlank: false,
					value: 0
				},{
					xtype: 'numberfield',
					name: 'employee.hourlyRevenue',
					fieldLabel: t("External fee"),
					width: 80,
					prefix: go.User.currency,
					allowBlank: false,
					value: 0
			}]}),
			this.externalRatePerActivity = new go.form.ArrayFieldGrid({
				columnWidth: .6,
				properties: ['activityId', 'externalRate'],
				defaultValues: {externalRate: 0},
				tbtitle: t('Rate per activity'),
				editable: false,
				name: "employee.activityRates",
				idField: "activityId",
				displayField: "name",
				entityStore: "Activity",
				extraColumns: [{
					dataIndex: 'externalRate',
					header: t('Rate'),
					editor: new Ext.form.NumberField()
				}],
				extraFields: ['externalRate']
			})
		]};
	},

	onLoad: function(user) {
		this.user = user;
		this.agreements.userId = user.id;
		this.agreements.store.setFilter('user', {employeeId: user.id});
	}

});


