import {BaseEntity, column, Config, createComponent, DataSourceStore, datasourcestore, t, Table} from "@intermesh/goui";
import {JmapDataSource, jmapds} from "@intermesh/groupoffice-core";

interface Business extends BaseEntity {
	name:string
}
export class BusinessTable extends Table<DataSourceStore<JmapDataSource<Business>>> {
	constructor() {

		const store = datasourcestore({
			dataSource: jmapds<Business>("Business"),
			queryParams: {
				limit: 20
			},
			sort: [{property: "name", isAscending: true}]
		});

		const columns = [
			column({
				header: t("Name"),
				id:"name",
				resizable: true,
				width: 312,
				sortable: true
			})
		];

		super(store, columns);
	}
}

export const businesstable = (config?: Config<BusinessTable>) => createComponent(new BusinessTable(), config);