Ext.define('go.modules.business.catalog.ArticleCombo', {
	extend: go.form.ComboBox,
	fieldLabel: t("Article"),
	hiddenName: 'articleId',
	tpl: new Ext.XTemplate(
		'<tpl for=".">',
		'<div class="x-combo-list-item">' +
		'<tpl if="!values.id"><b>' + t("Create new") + ':</b> </tpl><small>{number}</small> {name}' +
		'</div>',
		'</tpl>'
	),
	emptyText: t("Select article..."),
	displayField : 'name',
	valueField: 'id',
	triggerAction: 'all',
	pageSize: 50,
	mode:'remote',
	editable: true,
	selectOnFocus: true,
	forceSelection: true,
	allowBlank: true,
	listWidth: dp(500),
	allowNew: true,
	createDialog: go.modules.business.catalog.ArticleDialog,

	store: {
		xtype: "gostore",
		id: "id",
		fields: ['id', 'name', 'number', 'vatRateId', 'cost', 'price', 'categoryId', 'description', 'unit'],
		entityStore: "Article"
	},
	setBusinessId :  function(businessId) {
		this.store.setFilter("business", {businessId: businessId});
		this.allowNew = {businessId: businessId}
	}
});

Ext.reg("articlecombo",go.modules.business.catalog.ArticleCombo);