go.modules.business.catalog.ArticleDialog = Ext.extend(go.form.Dialog, {
	stateId: 'catalog-ArticleForm',
	title: t("Article"),
	entityStore: "Article",
	width: dp(800),
	height: dp(800),
	maximizable: true,
	collapsible: true,
	modal: false,
	formPanelLayout: "column",
	titleField: "number",

	onReady: function() {
		this.supr().onReady.call(this);

		this.changeBusiness();
	},

	initFormItems: function () {

		return [{
			xtype: "fieldset",
			columnWidth: .5,
			labelAlign: "top",
			defaults: {
				anchor: "100%"
			},
			items: [
				this.businessCombo = new go.modules.business.business.BusinessCombo({
					anchor: "-20",
					listeners: {
						change: function() {
							this.changeBusiness();
						},
						scope: this
					}
				}),

				{
					xtype: "textfield",
					fieldLabel: t("Name"),
					name: "name",
					allowBlank: false
				},
				{
					xtype: "textfield",
					fieldLabel: t("Number"),
					name: "number",
					allowBlank: true
				},
				{
					xtype: "textfield",
					itemId: "unit",
					fieldLabel: t("Unit"),
					flex: 1,
					name: "unit"
				},
				this.categoryCombo = new go.modules.business.business.CategoryCombo({
					fieldLabel: t("Finance category")
				})
			]
		}, {
			xtype: "fieldset",
			columnWidth: .5,
			labelAlign: "top",
			defaults: {
				anchor: "100%"
			},
			items: [
				{
					xtype: "contactcombo",
					fieldLabel: t("Supplier"),
					hiddenName: "supplierOrganizationId",
					allowBlank: true,
					isOrganization: true
				},
				{
					xtype: "textfield",
					fieldLabel: t("Supplier number"),
					name: "supplierNumber",
					allowBlank: true
				}, {
					xtype: "gonumberfield",
					fieldLabel: t("Cost"),
					name: "cost",
					decimals: 2,
					value: 0
				},
				{
					xtype: "gonumberfield",
					fieldLabel: t("Price"),
					name: "price",
					decimals: 2,
					value: 0
				},
				this.vatRateCombo = new go.modules.business.business.VatRateCombo({

				}),


			]
		}, {
			xtype: "fieldset",
			labelAlign: "top",
			columnWidth: 1,
			defaults: {
				anchor: "100%"
			},
			items: [
				{
					xtype: "textarea",
					grow: true,
					fieldLabel: t("Description"),
					name: "description",
					allowBlank: true
				},

				this.categoryField = new go.form.Chips({
					fieldLabel: t("Categories"),
					xtype: "chips",
					anchor: "-20",
					entityStore: "CatalogCategory",
					displayField: "name",
					valueField: 'id',
					allowNew: {
						entity: "CatalogCategory"
					},
					name: "categories",
					hideLabel: true
				})
			]
		}
		];
	},

	changeBusiness: function() {
		var me = this;
		if(!this.businessCombo.getValue()) {
			return;
		}
		go.Db.store("Business").single(this.businessCombo.getValue()).then(function (business) {
			me.vatRateCombo.setBusiness(business);
			me.categoryCombo.setBusiness(business);
		});
	},
});
