go.modules.business.finance.DebtorGrid = Ext.extend(go.grid.GridPanel, {

	initComponent: function () {

		this.store = new go.data.Store({
			fields: [
				'id',
				'contactId',
				'name',
				{name: 'graceUntil', type: 'date'},
				{name: 'lastActionAt', type: 'date'},
				{name: 'expiresAt', type: 'date'},
				{name: 'subTotal', type: "float"},
				{name: 'total', type: "float"},
				{name: 'count', type: "float"}
			],
			method: "Debtor/report",

			sortInfo: {
				field: "total",
				direction: "DESC"
			}
		});

		function valutaRenderer(v, meta, record) {
			return go.util.Format.number(v, 2);
		};

		Ext.apply(this, {
			columns: [{
				id: 'id',
				hidden: true,
				header: 'ID',
				width: dp(60),
				sortable: true,
				dataIndex: 'id'
			},{
				id: "name",
				dataIndex: "name",
				header: t("Customer", "addressbook", "community"),
				width: dp(200)
			},{
				xtype:"datecolumn",
				id: 'lastActionAt',
				header: t('Last action at'),
				width: dp(160),
				sortable: true,
				dataIndex: 'lastActionAt',
				hidden: true
			},{
				xtype:"datecolumn",
				dateOnly: true,
				id: 'graceUntil',
				header: t('Grace until'),
				width: dp(160),
				sortable: true,
				dataIndex: 'graceUntil',
				renderer: function(v) {
					if(v < new Date()) {
						return '-';
					} else
					{
						return go.util.Format.date(v);
					}
				}
			},{
				xtype:"datecolumn",
				id: 'expiresAt',
				header: t('Expires at'),
				width: dp(160),
				sortable: true,
				dataIndex: 'expiresAt'
			},{
				align: "right",
				dataIndex: "count",
				hidden: false,
				sortable: true,
				header: t("Count")
			},{
				align: "right",
				renderer: valutaRenderer,
				dataIndex: "subTotal",
				hidden: false,
				sortable: true,
				header: t("Subtotal")
			},{
				align: "right",
				renderer: valutaRenderer,
				dataIndex: "total",
				hidden: false,
				sortable: true,
				header: t("Total")
			}],
			viewConfig: {
				totalDisplay: true,
				emptyText: 	'<i>description</i><p>' +t("No items to display") + '</p>'
			},
			stateful: true,
			stateId: 'Debtor-grid'
		});

		go.modules.business.finance.FinanceDocumentGrid.superclass.initComponent.call(this);

	}
});

