go.modules.business.finance.FinanceDocumentDialog = Ext.extend(go.form.Dialog, {
	stateId: 'finance-FinanceDocumentForm',
	title: t("FinanceDocument"),
	entityStore: "FinanceDocument",
	width: dp(1200),
	height: dp(1000),
	maximizable: true,
	collapsible: true,
	modal: false,
	titleField: "number",
	type: "quote",

	initComponent: function() {
		this.supr().initComponent.call(this);

		this.formPanel.onBeforeLoad = async (entity)=> {
			this.type = this.getValues().type;
			this.bookCombo.store.setFilter("type", {type: this.type});
			await this.changeBook(entity.bookId, entity.businessModel);

			return entity;
		}
	},

	show : function() {
		if(!this.currentId) {
			this.bookCombo.store.setFilter("type", {type: this.type});
			if (this.bookCombo.getValue()) {
				this.changeBook(this.bookCombo.getValue()).then(() => {
					go.modules.business.finance.FinanceDocumentDialog.superclass.show.call(this);
				});
			} else {
				this.bookCombo.store.load().then(async () => {
					const first = this.bookCombo.store.getAt(0);
					if (!first) {
						Ext.MessageBox.alert(t("Warning"), t("You have no book setup yet"));
						go.modules.business.finance.FinanceDocumentDialog.superclass.show.call(this);
						return;
					}
					this.bookCombo.setValue(first.id);
					await this.changeBook(first.id, this.businessModel.getValue()).then(() => {
						go.modules.business.finance.FinanceDocumentDialog.superclass.show.call(this);
					})
				})
			}
		} else {
			go.modules.business.finance.FinanceDocumentDialog.superclass.show.call(this);
		}
	},

	onReady: function() {

		this.bookCombo.setDisabled(!!this.currentId);

		// add this after load and with a 20ms delay becuae Ext delays the check abd change events
		// for 10ms for some reason.
		setTimeout(() => {
			this.businessModel.on("change", (rg, businessModel) =>{
				this.changeBook(this.bookCombo.getValue(), businessModel.inputValue);
				this.selectCustomer.setValue(null);
				this.selectContact.setValue(null);
			})
		}, 500);

		go.modules.business.finance.FinanceDocumentDialog.superclass.onReady.call(this);

	},

	setLinkEntity: function (config) {
		switch (config.entity) {

			case  "FinanceDocument":
				function removeIds(data) {
					var newData = [];
					data.forEach(function (r) {
						var stripped = {};
						for (var i in r) {
							if (i == 'id' || i == 'documentId' || i == 'groupId') {
								continue;
							}
							stripped[i] = Ext.isArray(r[i]) ? removeIds(r[i]) : r[i];
						}
						newData.push(stripped);
					});

					return newData;
				}

				var itemGroups = removeIds(config.data.itemGroups);

				if(config.convertToPurchase) {
					itemGroups.forEach(function(ig) {
						ig.items.forEach(function(i) {
							i.unitPrice = i.unitCost;
							i.unitCost = null;
						})
					})
				}

				if(config.invert) {
					itemGroups.forEach(function(ig) {
						ig.items.forEach(function(i) {
							i.quantity = i.quantity * -1;
						})
					})
				}

				console.log(config.data);

				var v = {
					businessId: config.data.businessId,
					vatReverseCharge: config.data.vatReverseCharge,
					showTotals: config.data.showTotals,
					contactId: config.data.contactId,
					customerId: config.data.customerId,
					itemGroups: itemGroups,
					reference: config.data.reference,
					greeting: config.data.greeting,
					closing: config.data.closing,
					showPricePerLine: config.data.showPricePerLine,
					showTotals: config.data.showTotals,
					businessModel: config.data.businessModel,
					customFields: config.data.customFields,
				};
				this.on("ready", () => {
					this.setValues(v);
					if(v.customerId) {
						this.setRecipientFromCustomer(v.customerId)
					}

					this.createLinkButton.copyFrom(config.entity, config.entityId, [{name:"Project"}])
				}, this, {single: true})

				break;

			case 'Contact':
				if (config.data.isOrganization) {
					this.selectCustomer.setValue(config.entityId);
					this.setRecipientFromCustomer(config.entityId);

					this.vatReverseCharge.setValue(config.data.vatReverseCharge);
				} else {

					this.linkEntityId = config.entityId;

					this.selectContact.setValue(config.entityId);
					this.setCustomerFromContact(config.entityId);

				}
				break;

			case 'Project':

				if (config.data.company_id) {

					go.Db.store("Contact").single(config.data.company_id).then(org => {
						this.selectCustomer.setValue(org.id);
						this.vatReverseCharge.setValue(org.vatReverseCharge);

						if(config.data.contact_id) {
							this.selectContact.setValue(config.data.contact_id);
						}
					})


				} else if(config.data.contact_id) {
					this.selectContact.setValue(config.data.contact_id);
					this.setCustomerFromContact(config.data.contact_id);
				}
				break;
		}
	},
	changeBook: async function(bookId, businessModel) {
		if(!bookId) {
			return;
		}
		this.book = await go.Db.store("FinanceBook").single(bookId);
		this.business = await go.Db.store("Business").single(this.book.businessId);

		go.modules.business.finance.stores.vatRateStore.loadData({records: this.business.vatRates});
		go.modules.business.finance.ItemsField.prototype.vatRateId = this.business.vatRates.length ? this.business.vatRates[0].id : null;

		this.findByType("financeitemsfield").forEach((f) => {
			f.vatRateId = go.modules.business.finance.ItemsField.prototype.vatRateId;
			f.itemCfg.items[0].items.forEach(i => {
				if(i.xtype == "vatratecombo") {
					i.value  = f.vatRateId;
				}
			});

				f.findByType("formgroupitemcontainer").forEach(row => {

					const vatCombo = row.items.itemAt(0).items.itemAt(0).items.find(i => i.xtype == "vatratecombo");
					vatCombo.setValue(f.vatRateId)

			});
		});


		go.modules.business.finance.stores.categoryStore.loadData({records: this.business.categories});
		go.modules.business.finance.ItemsField.prototype.categoryCfg.hidden = this.business.categories.length === 0;

		this.businessModel.setVisible(this.book.businessModel == 'both');
		if(!businessModel) {
			this.businessModel.setValue(this.book.businessModel == 'both' ? 'b2b' : this.book.businessModel);
			businessModel = this.book.businessModel == 'both' ? 'b2b' : this.book.businessModel
		}
		if(businessModel == "b2c" != this.financeItemsConf.showPriceIncl) {
			this.financeItemsConf.showPriceIncl = businessModel == "b2c";
			if (this.rendered) {
				this.findByType("financeitemsfield").forEach((fi) => {
					fi.togglePriceIncl(this.financeItemsConf.showPriceIncl);
				});
			}
		}


		if(!this.currentId) {
			if (this.book.defaultGreeting) {
				this.setValues({greeting: this.book.defaultGreeting});
			}
			if (this.book.defaultClosing) {
				this.setValues({closing: this.book.defaultClosing});
			}
		}

		this.switchDocumentType(this.book.type);

		if(businessModel == "b2b") {

			if(this.linkEntityId) {
				this.selectContact.setValue(this.linkEntityId);
				this.setCustomerFromContact(this.linkEntityId);
			}
			this.selectContact.show();
			this.selectCustomer.setIsOrganization(true);
		} else
		{

			if(this.linkEntityId) {
				this.selectCustomer.setValue(this.linkEntityId);
			}

			this.selectContact.hide();
			this.selectCustomer.setIsOrganization(false);
		}

		this.itemGroups.doLayout();

		this.statusCombo.store.loadStatuses(this.book, true);
		this.statusCombo.setValue(this.statusCombo.getValue());
		//this.loadStatuses();
	},

	// loadStatuses : function() {
	// 	if(this.book.statuses.length) {
	// 		const data = [];
	// 		this.book.statuses.forEach(s => {
	// 			data.push([s.id, s.name, s.color]);
	// 		});
	//
	// 		this.statusCombo.store.loadData(data);
	// 		//for rendering value
	// 		this.statusCombo.setValue(this.statusCombo.getValue());
	//
	// 		this.statusCombo.show();
	// 	} else {
	// 		this.statusCombo.hide();
	// 	}
	// },

	initFormItems: function () {
		this.selectCustomer = new go.modules.community.addressbook.ContactCombo({
			anchor: '-20',
			fieldLabel: t("Customer"),
			hiddenName: 'customerId',
			isOrganization: undefined,
			allowBlank: false
		});

		this.selectCustomer.on("change", function (c, id) {

			if(id) {
				this.setRecipientFromCustomer(id);
			}
		}, this);

		this.selectContact = new go.modules.community.addressbook.ContactCombo({
			anchor: '-20',
			fieldLabel: t("Contact"),
			hiddenName: 'contactId',
			isCustomer: false,
			allowBlank: true
		});

		this.selectContact.on('select', function (combo, record) {
			this.setCustomerFromContact(record.data.id);
		}, this);


		var items = [{
			layout: "column",
			defaults: {
				columnWidth: .5,
				labelAlign: "top"
			},
			items: [{
				xtype: 'fieldset',
				items: [
					this.bookCombo = new go.modules.business.finance.FinanceBookCombo({
						anchor: "-20",
						listeners: {
							change: function(combo, bookId) {
								this.changeBook(bookId, this.businessModel.getValue());
							},
							scope: this
						}
					}),

					this.businessModel = new go.form.RadioGroup({
						hidden: true,
						hideMode: "offsets",
						anchor: '-20',
						xtype: 'radiogroup',
						fieldLabel: t("Business model"),
						name: "businessModel",
						value: null,

						items: [
							{
								boxLabel: t("B2B"),
								inputValue: 'b2b',

							},
							{
								boxLabel: t("B2C"),
								inputValue: 'b2c',

							}
						]

					}),

					this.selectContact,
					this.selectCustomer

				]
			},



				{
					xtype: "fieldset",
					items: [{
						fieldLabel: t("Number"),
						xtype: "textfield",
						name: "number",
						hidden: true,
						disabled: true
					},
						{
							xtype: "container",
							cls: "go-hbox",
							layout: "form",
							items:[{
								xtype: "datefield",
								fieldLabel: t("Date"),
								name: "date",
								value: new Date()
							}, {
								xtype: "datetimefield",
								allowBlank: true,
								fieldLabel: t("Delivery date"),
								name: "deliveredAt"
							}]
						},
						this.statusCombo = new go.modules.business.finance.FinanceStatusCombo({
							// hidden: true,
							anchor: "-20",
						})

						, {
							xtype: "textfield",
							fieldLabel: t("Reference"),
							name: "reference",
							anchor: "100%"
						},
						this.vatReverseCharge = new Ext.form.Checkbox({
							boxLabel: t("Reverse charge VAT"),
							name: "vatReverseCharge",
							hideLabel: true
						})]
				}]
		},

			{
				xtype: "fieldset",
				items: [
					{
						fieldLabel: t("Greeting"),
						xtype: 'gohtmleditor',
						name: 'greeting',
						anchor: "100%",
						grow: true
					}
					,
					new Ext.form.Checkbox({
						boxLabel: t("Show price and amounts per line"),
						name: "showPricePerLine",
						hideLabel: true,
						checked: true
					})
				]
			},

			this.createItemsFieldset(),

			{
				xtype: "fieldset",
				items: [
					{
						fieldLabel: t("Closing"),
						xtype: 'gohtmleditor',
						name: 'closing',
						anchor: "100%",
						grow: true
					}
				]
			},


		];

		this.itemGroups.on('setvalue', function(field, v) {
			this.calculateTotals();

			this.formPanel.getForm().trackReset();
		}, this);

		this.itemGroups.on("change", () => {
			this.calculateTotals();
		})

		// this.addPanel(this.createPaymentsPanel());

		this.addPanel(this.createRecipientPanel());

		return items;
	},


	createRecipientPanel: function() {
		this.recipientPanel = new Ext.Panel({
			title: t("Recipient"),
			layout: "column",
			items: [{
				columnWidth: .5,
				xtype: "fieldset",
				defaults: {
					anchor: "100%"
				},
				items: [
					{
						xtype: "textarea",
						height: dp(32),
						name: "customerTo",
						fieldLabel: t("To")
					},
					{
						xtype: "textarea",
						grow: true,
						height: dp(32),
						name: "customerStreet",
						fieldLabel: t("Street")
					},
					{
						xtype: "textfield",
						name: "customerZipCode",
						fieldLabel: t("Postal code")
					},
					{
						xtype: "textfield",
						name: "customerCity",
						fieldLabel: t("City")
					},
					{
						xtype: "textfield",
						name: "customerState",
						fieldLabel: t("State")
					},
					{
						xtype: "selectcountry",
						name: "customerCountryCode"

					}
				]
			},
				{
					columnWidth: .5,
					xtype: "fieldset",
					defaults: {
						anchor: "100%"
					},
					items: [

						{
							xtype: "usercombo",
							fieldLabel: t("Owner"),
							hiddenName: "createdBy",
							anchor: undefined

						}
					]
				}]
		});

		return this.recipientPanel;
	},

	switchDocumentType : function(type) {

		this.type = type;

		var f = this.formPanel.form;
		this.origTitle = go.modules.business.finance.util.humanType(type);

		switch(type) {
			case 'quote':
				// this.tabPanel.unhideTabStripItem(this.frontPagePanel);
				// this.tabPanel.hideTabStripItem(this.paymentsPanel);
				//this.itemGroups.itemCfg.items[0].items[3].itemCfg.items[3].hidden = false;
				this.selectCustomer.setFieldLabel(t("Customer"));
				break;
			case 'salesorder':
				// this.tabPanel.hideTabStripItem(this.frontPagePanel);
				f.findField('deliveredAt').show();
				this.selectCustomer.setFieldLabel(t("Customer"));
				// this.tabPanel.hideTabStripItem(this.paymentsPanel);
				break;
			case 'salesinvoice':
				// this.tabPanel.hideTabStripItem(this.frontPagePanel);
				// this.selectContact.hide();
				this.selectCustomer.setFieldLabel(t("Customer"));
				break;
			case 'purchaseorder':
				// this.tabPanel.hideTabStripItem(this.frontPagePanel);
				f.findField('deliveredAt').show();
				this.selectCustomer.setFieldLabel(t("Supplier"));
				// this.tabPanel.hideTabStripItem(this.paymentsPanel);
				break;
			case 'purchaseinvoice':
				// this.selectContact.hide();
				// this.tabPanel.hideTabStripItem(this.frontPagePanel);
				this.selectCustomer.setFieldLabel(t("Supplier"));
				f.findField('number').show();
				f.findField('number').setDisabled(false);
				break;

		}

		this.updateTitle();
	},


	setCustomerFromContact: function(id) {
		var me = this;
		go.Db.store("Contact").single(id).then(function (contact) {
			if (contact.organizationIds.length > 0) {
				me.selectCustomer.setValue(contact.organizationIds[0]);

				me.setRecipientFromCustomer(contact.organizationIds[0]);

				go.Db.store("Contact").single(contact.organizationIds[0]).then(function (org) {
					me.vatReverseCharge.setValue(org.vatReverseCharge);
				});
			}
		});
	},

	setRecipientFromCustomer: function(id) {
		go.Db.store("Contact").single(id).then((org) => {
			this.vatReverseCharge.setValue(org.vatReverseCharge);

			this.setValues({
				customerTo: org.name
			});

			let address;
			for( let a of org.addresses) {
				if(!address || a.type == "postal") {
					address = a;
				}
			};

			if(address) {

				this.setValues({
					customerStreet: address.address,
					customerZipCode: address.zipCode,
					customerCity: address.city,
					customerState: address.state,
					customerCountryCode: address.countryCode || address.country,
				});
			}


		});
	},

	// createPaymentsPanel : function() {
	// 	this.paymentsPanel = new Ext.Panel({
	// 		title: t("Payments"),
	// 		items: [
	// 			{
	// 				xtype: "fieldset",
	// 				items: [
	// 					{
	// 						style: "margin-top: " + dp(16) + "px",
	// 						xtype: "container",
	// 						hideLabel: true,
	// 						layout: "hbox",
	// 						items: [{
	// 							xtype: "box",
	// 							width: dp(48)
	// 						}, {
	// 							width: dp(148),
	// 							xtype: "box",
	// 							html: t("Date")
	// 						}, {
	// 							flex: 4,
	// 							xtype: "box",
	// 							html: t("Description")
	// 						}, {
	// 							flex: 2,
	// 							xtype: "box",
	// 							html: t("Amount")
	// 						}]
	// 					},
	// 					{
	// 						xtype: "formgroup",
	// 						name: "payments",
	// 						addButtonText: t("Add payment"),
	// 						listeners: {
	// 							scope: this,
	// 							newitem: function(fg, item) {
	// 								item.formField.findField("amount").setValue(this.formPanel.entity.totalPrice);
	// 							}
	// 						},
	// 						itemCfg: {
	// 							items: [{
	// 								xtype: "compositefield",
	// 								hideLabel: true,
	// 								items: [{
	// 									xtype: "hidden",
	// 									name: "id" //for keeping records
	// 								}, {
	// 									width: dp(140),
	// 									name: "date",
	// 									xtype: "datefield",
	// 									setFocus: true,
	// 									value: new Date()
	// 								}, {
	// 									flex: 4,
	// 									xtype: "textarea",
	// 									//height: dp(48),
	// 									allowBlank: true,
	// 									grow: true,
	// 									name: "description",
	// 									growMin: dp(24),
	// 									height: dp(24),
	// 									setSize: function (w, h) {
	// 										//somehow needed in hbox layout :(
	// 										Ext.form.TextArea.prototype.setSize.call(this, w, h);
	// 										this.autoSize();
	// 									},
	// 									listeners: {
	// 										autosize: function (field, h) {
	// 											//needed for making hbox layout grow along
	// 											field.ownerCt.setHeight(h);
	// 										}
	// 									}
	// 								}, {
	// 									flex: 2,
	// 									name: "amount",
	// 									xtype: "gonumberfield",
	// 									value: 0
	// 								}]
	// 							}]
	// 						}
	// 					}]
	// 			}]
	// 	});
	//
	// 	return this.paymentsPanel;
	// },

	calculateTotals: function() {
		const itemGroups = this.itemGroups.getValue();

		let totalCost = 0, totalPriceEx = 0, totalPriceIncl = 0;

		itemGroups.forEach((g) => {
			g.items.forEach(i => {
				totalCost += i.unitCost * i.quantity;
				totalPriceEx += i.unitPrice * i.quantity;

				const vatRate =	i.vatRateId ? go.modules.business.finance.stores.vatRateStore.getById(i.vatRateId).data.rate : 0;

				totalPriceIncl += ( i.unitPrice * i.quantity * (100 + vatRate) / 100 );

			})
		})

		this.totalCostField.setValue(totalCost);
		this.totalPriceExField.setValue(totalPriceEx);
		this.totalPriceInclField.setValue(totalPriceIncl);
		this.totalMarginField.setValue(totalCost ? totalPriceEx / totalCost * 100 - 100 : 0);

	},

	createItemsFieldset : function() {

		this.financeItemsConf = {
			itemId: 'financeitemsfield',
			xtype: "financeitemsfield",
			decimals: go.Modules.get("business", "finance").settings.decimals,
			showPriceIncl: false
		};

		return {
			// title: t("Items"),
			xtype: "fieldset",
			items: [
				this.itemGroups = new go.form.FormGroup({

					xtype: "formgroup",
					sortable: true,
					name: "itemGroups",
					addButtonText: t("Add group"),
					required: true,
					listeners: {
						scope: this,
						change: function(field) {
							this.calculateTotals();
						}
					},
					itemCfg: {
						items: [
							{
								style: {"margin-left": "0", "margin-top": "0","margin-right": "0"},
								xtype: "fieldset",
								border: 1,
								items: [
									{
										xtype: "hidden",
										name: "id"
									},
									{
										cls: "finance-document-item-group-title go-hbox condensed-form",
										xtype: "container",
										layout: "form",
										items: [{
											xtype: "textfield",
											name: "title",
											fieldLabel: t("Title"),
											allowBlank: true,
											flex: 1
										},{
											xtype: "selectfield",
											options: [
												['group', t('Group with items')],
												['groupwithtotal', t('Group with total')],
												['single', t('Single line item')],
												['hidden', t('Hidden')]],
											name: "showAs",
											value: "group",
											fieldLabel: t("Show as")
										}]

									},

									this.financeItemsConf
								]
							}
						]
					}
				}),

				{
					xtype: "container",
					layout: "form",
					cls: "go-hbox condensed-form",

					items: [
						{
							flex: 8,
							xtype: "checkbox",
							name: "showTotals",
							boxLabel: t("Show totals"),
							checked: true
						},
						this.totalCostField = new go.form.NumberField({
							submit: false,
							flex: 2,
							readOnly: true,
							fieldLabel: t("Total cost"),
							decimals: go.Modules.get("business", "finance").settings.decimals
						}),
						this.totalPriceExField = new go.form.NumberField({
							submit: false,
							flex: 2,
							readOnly: true,
							fieldLabel: t("Total price"),
							decimals: go.Modules.get("business", "finance").settings.decimals
						}),
						this.totalPriceInclField = new go.form.NumberField({
							submit: false,
							flex: 2,
							readOnly: true,
							fieldLabel: t("Total price Incl."),
							decimals: go.Modules.get("business", "finance").settings.decimals
						}),
						this.totalMarginField = new go.form.NumberField({
							submit: false,
							flex: 2,
							readOnly: true,
							fieldLabel: t("Total margin"),
							decimals: 0
						})
					]
				}


			]
		};
	}
});
