
go.modules.business.finance.ItemsField = Ext.extend(go.form.FormGroup, {
	xtype: "formgroup",
	sortable: true,
	sortColumn: "order",
	name: "items",
	addButtonText: t("Add item"),
	headers: true,
	required: true,
	decimals: 2,
	ddGroup: "finance-document-items",
	showPriceIncl: false,

	vatRateId: undefined,

	categoryCfg : {
		hidden: true,
		flex: 2,
		xtype: "categorycombo",
		itemId: 'categoryId',
		store: go.modules.business.finance.stores.categoryStore
	},

	initComponent: function() {

		this.buildItemConfig();

		go.modules.business.finance.ItemsField.superclass.initComponent.call(this);

	},

	initBbar: function() {

		go.modules.business.finance.ItemsField.superclass.initBbar.call(this);


		if(go.Modules.isAvailable("business", "catalog")) {
			this.bbar.push(
				new Ext.Button({
					text: t("Add from catalog"),
					handler: function () {
						const win = new go.modules.business.catalog.SelectArticleWindow();
						win.handler = (records) => {

							const v = this.getValue();
							this.setValue(v.concat(records.map((record) => {
								return go.modules.business.catalog.articleToItem(record.data);
							})));
							win.close();

						}
						win.show();
					},
					scope: this
				})
			)
		}

		this.bbar.push(
			this.addButton = new Ext.Button({
				//iconCls: this.addButtonIconCls,
				text: t("Add page break"),
				handler: function() {
					const wrap = this.addRow();

					wrap.formField.setValue({quantity: 0, description: "__PAGEBREAK__"});

				},
				scope: this
			})
		);
	},

	togglePriceIncl: function(show) {

		this.showPriceIncl = show;

		const index = go.Modules.isAvailable("business", "catalog") ? 5 : 4,
			row = this.itemCfg.items[0];

		//unit price
		row.items[index].hidden = this.showPriceIncl;
		row.items[index].decimals = this.showPriceIncl ? 10 : this.decimals;
		//unitPriceIncl
		row.items[index + 1].hidden = !this.showPriceIncl;

		this.setValue(this.getValue());

		if(this.items.getCount() == 0) {
			this.addPanel(true);
		}
	},


	buildItemConfig : function() {





		this.itemCfg = {
			columnWidth: 1,

			xtype: "formcontainer",
			listeners: {
				afterlayout: function(formContainer) {
					const formDialog = formContainer.findParentByType("formdialog");

					const unitCostField = formContainer.findField("unitCost"), marginField = formContainer.findField("margin");

					if(formDialog.type != "purchaseinvoice" && formDialog.type != "purchaseorder") {
						if(go.Modules.get("business", "finance").settings.itemsShowUnitCost) {
							unitCostField.show();
						}
						unitCostField.setDisabled(false);

						if(go.Modules.get("business", "finance").settings.itemsShowMargin) {
							marginField.show();
						}
					}else
					{
						unitCostField.hide();
						unitCostField.setDisabled(true);
						marginField.hide();
					}

					if(go.Modules.isAvailable("business", "catalog")) {
						const articleCombo = formContainer.findField("articleId");

						if(formDialog.book) {
							articleCombo.setBusinessId(formDialog.book.businessId);
						}
					}

				}
			},


				items: [
					{
						itemId: "itemrow1",
						xtype: "container",
						layout: "form",
						cls: "go-hbox condensed-form",
						items:[
							{
								xtype: "hidden",
								name: "id" //for keeping records
							},{
								flex: 1,
								name: "quantity",
								xtype: "gonumberfield",
								setFocus: true,
								value: 1,
								fieldLabel: t("Quantity"),
								decimals: 2
							},
							{
								xtype: "textfield",
								itemId: "unit",
								fieldLabel: t("Unit"),
								flex: 1,
								name: "unit",
								hidden: !go.Modules.get("business", "finance").settings.itemsShowUnit
							},

							{
								itemId: "unitCost",
								fieldLabel: t("Unit cost"),
								flex: 2,
								name: "unitCost",
								xtype: "gonumberfield",
								value: 0,
								hidden: !go.Modules.get("business", "finance").settings.itemsShowUnitCost,
								decimals: this.decimals,
								listeners: {
									scope: this,
									change: function(field, v) {

										if(!v) {
											return;
										}

										// this.updateMarginFromUnitPrice(field.ownerCt);

										const unitCost = field.ownerCt.items.get("unitCost").getValue();

										const margin = field.ownerCt.items.get("margin").getValue();
										if(margin) {
											// this.updateMarginFromUnitPrice(field.ownerCt);

											const unitPriceFld = field.ownerCt.items.get("unitPrice");

											unitPriceFld.setValue(unitCost * (100 + margin) / 100)
										}

									}
								},

							}, {
								itemId: "unitPrice",
								fieldLabel: t("Unit price"),
								flex: 2,
								name: "unitPrice",
								xtype: "gonumberfield",
								listeners: {
									scope: this,
									change: (field, v) => {

										this.updatePriceIncl(field.ownerCt);

										this.updateMarginFromUnitPrice(field.ownerCt);


									}
								},
								value: 0,
								hidden: this.showPriceIncl,
								decimals: this.showPriceIncl ? 10 : this.decimals
							}, {
								hidden: !this.showPriceIncl,
								itemId: "unitPriceIncl",
								submit: false,
								fieldLabel: t("Price Incl."),
								flex: 2,
								name: "unitPriceIncl",
								xtype: "gonumberfield",
								listeners: {
									scope: this,
									render: (field) => {

										this.updatePriceIncl(field.ownerCt);


									},
									change: (field, v) => {
										const unitPrice = field.ownerCt.items.get("unitPrice");

										if(!unitPrice) {
											return;
										}

										const vatRateId = field.ownerCt.items.get("vatRate").getValue(),
											vatRate =	vatRateId ? go.modules.business.finance.stores.vatRateStore.getById(vatRateId).data.rate : 0;

										unitPrice.setValue( field.getValue() * 100 / (100 + vatRate));

										this.updateMarginFromUnitPrice(field.ownerCt);
									}
								},
								value: 0,
								decimals: this.decimals
							},
							{
								hidden: !go.Modules.get("business", "finance").settings.itemsShowMargin,
								itemId: "margin",
								submit: false,
								fieldLabel: t("Margin"),
								flex: 1.2,
								name: "margin",
								xtype: "gonumberfield",
								value: 0,
								listeners: {
									scope: this,
									render: function(field) {

										const unitCost = field.ownerCt.items.get("unitCost").getValue();
										if(!unitCost) {
											return;
										}
										const unitPrice = field.ownerCt.items.get("unitPrice").getValue();

										field.setValue((unitPrice / unitCost ) * 100 - 100);


									},
									change: function(field, v) {
										const unitCost = field.ownerCt.items.get("unitCost").getValue();

										if(!unitCost) {
											return;
										}

										const unitPriceFld = field.ownerCt.items.get("unitPrice");

										unitPriceFld.setValue(unitCost * (100 + v) / 100);

										this.updatePriceIncl(field.ownerCt);
									}
								},
								decimals: 2
							},
							this.categoryCfg,
							{
								flex: 2,
								xtype: "vatratecombo",
								itemId: 'vatRate',
								fieldLabel: t("VAT rate"),
								value: this.vatRateId,
								store: go.modules.business.finance.stores.vatRateStore,
								listeners: {
									scope: this,
									// render: function (cmp) {
									//
									// 	if (!cmp.getValue()) {
									// 		cmp.setValue(this.vatRateId);
									// 	}
									//
									// 	go.modules.business.finance.stores.vatRateStore.on("load", this.onLoadFn = function () {
									//
									// 		// sometimes the component has been replaced by loading the dialog.
									// 		if (cmp.isDestroyed) {
									// 			return;
									// 		}
									//
									// 		this.vatRateId = go.modules.business.finance.ItemsField.prototype.vatRateId;
									// 		if (!cmp.getValue()) {
									// 			cmp.setValue(this.vatRateId);
									// 		}
									// 	});
									// },
									// destroy: function (cmp) {
									// 	go.modules.business.finance.stores.vatRateStore.un("load", this.onLoadFn);
									// },
									change: function (field) {
										this.updatePriceIncl(field.ownerCt);
									}

								}
							}

						]
					}
				]



		};


		const desc = {
			fieldLabel: t("Description"),
			itemId:"itemrow2",
			xtype: "textarea",
			//height: dp(48),

			allowBlank: false,
			grow: true,
			name: "description",
			growMin : dp(24),
			height: dp(24),
			listeners: {
				setvalue: function(field, v) {
					if(v == "__PAGEBREAK__") {
						if(!field.ownerCt.hidden) {
							field.ownerCt.hide();
							field.ownerCt.ownerCt.add(new Ext.form.Label({html: "<div class='pagebreak'>-- "+t("Page break")+' -- </div>'}));
							field.ownerCt.ownerCt.doLayout();
						}
					}
				}
			}

		};

		if(go.Modules.get("business", "finance").settings.itemsDescriptionRow ) {
			desc.width = "100%";
			this.itemCfg.items.push(desc,

				{
					xtype: "component",
					autoEl: "hr"
				});
		} else {
			desc.flex = 4;
			this.itemCfg.items[0].items.splice(2, 0, desc)
		}

		if(go.Modules.isAvailable("business", "catalog")) {

			this.itemCfg.items[0].items.splice(2, 0, {
				xtype: "articlecombo",
				flex: 3,
				listeners: {
					select: function(combo, record, index) {


						//var record = combo.store.getById(articleId);
						var fc = combo.findParentByType("formcontainer");

						if(fc.findField("description").getValue() != "" && !confirm(t("Do you want to overwrite this line with the data of the article?"))) {
							return;
						}

						fc.setValue(go.modules.business.catalog.articleToItem(record.data));

						fc.findField("vatRateId")
							.setValue(record.data.vatRateId);

						setTimeout( () => {
							fc.findField("description").focus(true);
						})
					}
				}
			})
		}
	},

	updatePriceIncl : function(row) {

		const unitPrice = row.items.get("unitPrice"), unitPriceIncl = row.items.get("unitPriceIncl")

		if(!unitPrice) {
			return;
		}

		const vatRateId = row.items.get("vatRate").getValue();
		const	vatRate =	vatRateId ? go.modules.business.finance.stores.vatRateStore.getById(vatRateId).data.rate : 0;

		unitPriceIncl.setValue( unitPrice.getValue() *  (100 + vatRate) / 100);


	},

	updateMarginFromUnitPrice : function(row) {
		const unitCost = row.items.get("unitCost").getValue();
		const unitPrice = row.items.get("unitPrice"), unitPriceIncl = row.items.get("unitPriceIncl")

		if (!unitCost) {
			return;
		}

		const marginFld = row.items.get("margin");

		marginFld.setValue((unitPrice.getValue() / unitCost) * 100 - 100);
	}

});

Ext.reg("financeitemsfield", go.modules.business.finance.ItemsField);