go.modules.business.finance.SalesReportWindow = Ext.extend(go.Window, {

	title: t("Sales report"),

	width: dp(1200),
	height: dp(960),

	layout: 'fit',

	autoScroll: true,
	maximizable: true,

	initComponent: function() {

		this.yearly = new go.modules.business.finance.YearlyReportPanel();

		this.yearly.yearlySalesChart.on("chartclick", (chart, index, label, res) => {

			const year = label.split("-")[0].trim();

			this.monthly.load(this.bookId, year);
			this.cardPanel.getLayout().setActiveItem(1);
		});

		this.monthly = new go.modules.business.finance.MonthlyReportPanel();

		this.cardPanel = new Ext.Panel({
			activeItem: 0,
			layout: "card",
			items:[this.yearly, this.monthly]
		})

		this.items = [this.cardPanel];

		go.modules.business.finance.SalesReportWindow.superclass.initComponent.call(this);
	},

	load: async function(bookId) {
		this.bookId = bookId;
		this.book = await go.Db.store("FinanceBook").single(bookId);
		// this.yearField.setValue(year);
		this.setTitle(t("Sales report") + " - " + this.book.name);

		this.yearly.load(bookId);
		// this.monthly.load(bookId, year);
	},

});