Ext.ns("{namespace}.customfield");

{namespace}.customfield.{entityName} = Ext.extend(go.customfields.type.Text, {

	name : "{entityName}",

	label: t("{entityName}"),

	iconCls: "ic-settings",

	/**
	* Return dialog to edit this type of field
	*
	* @returns {go.customfields.FieldDialog}
	*/
	getDialog : function() {
		return new  {namespace}.customfield.{entityName}Dialog();
	},

	/**
	* Render the custom field value for the detail views
	*
	* @param {mixed} value
	* @param {object} data Complete entity
	* @param {object} customfield Field entity from custom fields
	* @param {go.detail.Property} cmp The property component that renders the value
	* @returns {unresolved}
	*/
	renderDetailView: function (value, data, customfield, cmp) {
		if(!value) {
			return "";
		}

		go.Db.store("{entityName}").single(value).then(function(entity) {
			cmp.setValue('<a href="#' + go.Entities.get("{entityName}").getRouterPath(entity.id) + '">' +
				entity.customFields.{searchNameFld} + '</a>');
		}).catch(function() {
			cmp.setValue(t("Not found or no access"));
		}). finally(function() {
			cmp.setVisible(true);
		});
	},

	/**
	 * Returns config object to create the form field
	 *
	 * @param {object} customfield customfield Field entity from custom fields
	 * @param {object} config Extra config options to apply to the form field
	 * @returns {Object}
     */
	createFormFieldConfig: function (customfield, config) {
		let c = {namespace}.customfield.{entityName}.superclass.createFormFieldConfig.call(this, customfield, config);

		c.xtype = "{entityName}combo";
		c.hiddenName = "customFields." + c.customfield.databaseName;
		c.permissionLevel = go.permissionLevels.read;
		c.allowNew = customfield.options.allowNew;

		delete c.name;

		return c;
	},


	getFieldDefinition : function(field) {
		//Use a promise type to prefetch the entity data before store loads
		let def = this.supr().getFieldDefinition(field);
		def.type = 'promise';
		def.promise = function(record) {
			let id = record[this.name];
			if(!id && record.customFields) {
				id = record.customFields[this.customField.databaseName];
			}
			if(!id) {
				return Promise.resolve(null);
			} else {
				return go.Db.store("{entityName}").single(id);
			}
		}
		return def;
	},

	getRelations : function(customfield) {
		let r = {};
		r[customfield.databaseName] = {store: "{entityName}", fk: customfield.databaseName};
		return r;
	},

	getColumn : function(field) {
		let c = {namespace}.customfield.{entityName}.superclass.getColumn.call(this, field);
		c.renderer = function(v) {
			return v ? v.customFields.{searchNameFld} : "";
		};
		return c;
	},

	getFilter : function(field) {
		return {
			name: field.databaseName,
			type: "{namespace}.{entityName}Combo",
			typeConfig: this.createFormFieldConfig(field),
			multiple: true,
			wildcards: true,
			title: field.name
		};
	}
});
