/* global Ext, go, GO */

{namespace}.{entityName}Combo = Ext.extend(go.form.ComboBox, {
	fieldLabel: t("{entityName}"),
	hiddenName: '{entityName}Id',
	anchor: '100%',
	emptyText: t("Please select..."),
	pageSize: 50,
	valueField: 'id',
	displayField: 'customFields.{searchNameFld}',
	triggerAction: 'all',
	editable: true,
	selectOnFocus: false,
	forceSelection: true,

	initComponent: function () {
		this.allowNew = this.allowNew || false;

		const comboFilter = {
			permissionLevel: this.permissionLevel || go.permissionLevels.write
		};

		Ext.applyIf(this, {
			store: new go.data.Store({
				fields: [
					"id"
				],
				entityStore: "{entityName}",
				sortInfo: {
					field: "id",
					direction: 'ASC'
				},
				filters: {
					combo: comboFilter
				},
				enableCustomFields: true
			})
		});

		this.tpl = new Ext.XTemplate(
			'<tpl for=".">\
				<div class="x-combo-list-item">\
					<div class="wrap">\
						<div><tpl if="!values.id"><strong>' + t("Create new") + ':</strong> </tpl>{[this.getDisplayName(values)]}</div>\
					</div>\
				</div>\
			</tpl>', {
			getDisplayName: (values) => {
				return values["customFields.{searchNameFld}"];
			}
		});

		{namespace}.{entityName}Combo.superclass.initComponent.call(this);

	}
});

Ext.reg("{entityName}combo", {namespace}.{entityName}Combo);
