/**
 * @see go.Modules.GroupRights for specs:
 *
 * Assign groups and their rights to this module. As there is only the "manage" permission, we save this upon finally
 * submitting the entire studio module. This happens in go.modules.business.studio.StudioWizard
 */
go.modules.business.studio.WizardGroupRightsPanel = Ext.extend(Ext.Panel, {
	stateful: false,
	stateId: 'studio-group-rights',


	initComponent: function () {
		let cols = [{
				xtype: 'gridcolumn',
				header: t('Group'),
				dataIndex: 'groupId',
				align: 'left',
				id: 'groupName',
				renderer: function (v, m, r) {
					return '<i class="icon">' + (r.data.isUserGroupFor ? 'person' : 'people') + '</i>&nbsp;&nbsp;' + r.data.groupName;
				}
			}],
			fields = [
				'groupId',
				{
					name: 'groupName', type: "promise", promise: (data) => {
						return go.Db.store('Group').single(data.groupId).then(e => e.name)
					}
				},
				{
					name: 'isUserGroupFor', type: "promise", promise: (data) => {
						return go.Db.store('Group').single(data.groupId).then(e => e.isUserGroupFor)
					}
				}
			];

		Ext.apply(this, {
			autoScroll: true,
			layout: "fit",
			items: [this.formPanel = new Ext.FormPanel({
				cls: "go-form",
				layout: "form",
				tbar: [{
					xtype: 'gocombo',
					editable: true,
					displayField: "name",
					valueField: "id",
					width: 500,
					triggerAction: "all",
					listWidth: 500,
					pageSize: 50,
					store: {
						xtype: "gostore",
						fields: ["id", "name", "isUserGroupFor"],
						entityStore: "Group",
						listeners: {
							load: (store) => {
								this.filterUnused(store);
							}
						}
					},
					emptyText: t("Add group"),
					listeners: {
						expand: (cb) => {
							this.filterUnused(cb.store);
						},
						select: (cb, record) => {
							this.gridfield.stopEditing();
							this.gridfield.store.insert(0, new Ext.data.Record({
								groupId: record.data.id,
								groupName: record.data.name,
								isUserGroupFor: record.data.isUserGroupFor
							}));
							this.data.permissions = this.data.permissions || {};
							this.data.permissions[record.data.id] = {groupName: record.data.name};
							cb.setValue(null);
						}
					},
				}],
				items: [
					this.gridfield = new go.form.GridField({
						stateId: "studio-module-permissions",
						autoExpandColumn: "groupName",
						hideHeaders: false,
						// minHeight: 500,
						height: 650,
						cls: '',
						name: "permissions",
						store: {
							xtype: "gostore",
							autoDestroy: true,
							root: "records",
							fields: fields,
						},
						mapKey: 'groupId',
						columns: cols
					})]
			})]
		});

		this.supr().initComponent.call(this);

		this.gridfield.getBottomToolbar().hide(); // replace with tbar
	},

	show: function () {
		this.setTitle(t("Permissions") + ' ' + this.data.name);

		this.configureGrid(this.data.rights);

		this.supr().show.call(this);
		this.formPanel.form.setValues(this.data);
	},

	configureGrid: function (rights) {
		this.permissionsTypes = rights;
		let cols = [{
				xtype: 'gridcolumn',
				header: t('Group'),
				dataIndex: 'groupId',
				align: 'left',
				id: 'groupName',
				renderer: function (v, m, r) {
					return '<i class="icon">' + (r.data.isUserGroupFor ? 'person' : 'people') + '</i>&nbsp;&nbsp;' + r.data.groupName;
				}
			}],
			fields = [
				'groupId',
				{
					name: 'groupName', type: "promise", promise: (data) => {
						return go.Db.store('Group').single(data.groupId).then(e => e.name)
					}
				},
				{
					name: 'isUserGroupFor', type: "promise", promise: (data) => {
						return go.Db.store('Group').single(data.groupId).then(e => e.isUserGroupFor)
					}
				}
			];
		for (let prop of rights) {
			fields.push({name: prop, mapping: 'rights.' + prop});
			cols.push({
				id: prop,
				header: t(prop, this.data.name, this.data.package),
				dataIndex: prop,
			})
		}

		this.gridfield.reconfigure(new go.data.Store({
			autoDestroy: true,
			root: "records",
			fields: fields
		}), new Ext.grid.ColumnModel({
			defaults: {
				width: dp(200),
				xtype: 'checkcolumn',
				sortable: false,
				hideable: false,
				draggable: false,
				menuDisabled: true,
				align: 'center'
			},
			columns: cols
		}));

		this.gridfield.store.on('remove', function (store, record) {
			delete this.data.permissions[record.data.groupId];
		}, this)
	},

	filterUnused: function (store) {
		store.filterBy(function (record, id) {
			if (record.data.name === 'Admins') {
				return false;
			}
			return !this.data.permissions || this.data.permissions[id] === undefined
		}, this);
	},

})
