/* global go, Ext */

go.modules.business.support.SettingsPanel = Ext.extend(Ext.Panel, {
	title: t("Support"),
	iconCls: 'ic-help',
	labelWidth: 125,
	layout: "form",
	initComponent: function () {

		//The account dialog is an go.form.Dialog that loads the current User as entity.
		this.items = [{
			xtype: "fieldset",
			title: t("Display options for tasklists"),
			items: [
				{
					xtype: "tasklistcombo",
					hiddenName: "supportSettings.defaultTasklistId",
					fieldLabel: t("Default tasklist"),
					role: 'support',
					allowBlank: true
				},
				this.defaultTasklistOptions = new go.form.RadioGroup({
					allowBlank: true,
					fieldLabel: t('Start in'),
					name: 'supportSettings.rememberLastItems',
					columns: 1,

					items: [
						{
							boxLabel: t("Default tasklist"),
							inputValue: false
						},
						{
							boxLabel: t("Remember last selected tasklist"),
							inputValue: true
						}
					]
				})
			]
		}
		];

		go.modules.business.support.SettingsPanel.superclass.initComponent.call(this);
	}
});
