import {
	arrayfield,
	ArrayField,
	btn, comp,
	Component,
	Config, ContainerField,
	containerfield, displayfield, Form, Format,
	HtmlField,
	htmlfield, menu,
	Notifier,
	root,
	t
} from "@intermesh/goui";
import {client} from "@intermesh/groupoffice-core";


export class CommentEditor extends Component {

	private htmlEditor: HtmlField;
	readonly attachments: ArrayField;

	constructor() {
		super();
		this.cls = "vbox";

		this.items.add(
			this.htmlEditor = htmlfield({
				toolbarItems: [
					"bold", "italic", "underline",
					"-",
					"foreColor", "removeFormat",
					"-",
					"insertOrderedList",
					"insertUnorderedList",
					"-",
					"indent",
					"outdent",
					"-",
					"image"
				],

				flex: 1,
				name: "text",
				cls: "frame-hint",
				hint: t("Attach files by dropping or pasting them"),
				label: t("Message"),
				required: true,
				listeners: {
					attach: (htmlfield, file) => {

						client.upload(file).then(r => {

							const atts = this.attachments.value;
							atts.push({
								name: r.name,
								blobId: r.id
							});
							this.attachments.value = atts;

							Notifier.success("Uploaded " + file.name + " successfully");
						}).catch((err) => {
							console.error(err);
							Notifier.error("Failed to upload " + file.name);
						}).finally(() => {
							root.unmask();
						});


					},
					insertimage: (htmlfield, file, img) => {
						root.mask();

						client.upload(file).then(r => {
							if (img) {
								img.dataset.blobId = r.id;
								img.removeAttribute("id");
							}
							Notifier.success("Uploaded " + file.name + " successfully");
						}).catch((err) => {
							console.error(err);
							Notifier.error("Failed to upload " + file.name);
						}).finally(() => {
							root.unmask();
						});
					}
				}
			}),

			this.attachments = arrayfield({
				name: "attachments",
				buildField: (v) => {
					return containerfield({
							cls: "hbox"
						},
						displayfield({
							escapeValue: false,
							flex: 1,
							value: `<i class="icon">description</i> ${Format.escapeHTML(v!.name)}`,
						}),
						btn({
							icon: "delete",
							handler: (button, ev) => {
								button.findAncestorByType(ContainerField)!.remove()
							}
						})
					)
				}
			})
		);


	}
}

export const commenteditor = (config?: Config<CommentEditor>) => Object.assign(new CommentEditor(), config);