/**
* Copyright Intermesh
*
* This file is part of Group-Office. You should have received a copy of the
* Group-Office license along with Group-Office. See the file /LICENSE.TXT
*
* If you have questions write an e-mail to info@intermesh.nl
*
* @copyright Copyright Intermesh
* @author {authorName} <{email}>
*/

Ext.onReady(function() {
	Ext.override(go.modules.community.addressbook.ContactDialog, {
		closeOnSave: false,
		initComponent: go.modules.community.addressbook.ContactDialog.prototype.initComponent.createSequence(function() {
			this.businessPanel.items.itemAt(1).add(
				new Ext.Button({
					text: "VIES VAT check",
					handler: async function() {

						this.getEl().mask(t("Loading..."));

						const v = this.formPanel.getValues();

						let countryCode = "";
						v.addresses.forEach((address) => {
							if(!countryCode && !countryCode) {
								countryCode = address.countryCode;
							}
						});

						if(!countryCode) {
							Ext.MessageBox.alert(t("No address"), t("Please add an address with a country"));
							return;
						}

						if(!v.vatNo) {
							Ext.MessageBox.alert(t("No VAT"), t("Please set a VAT number"));
							return;
						}


						try {
							const response = await go.Jmap.request({
								method: "business/vies/VIES/validate",
								params: {
									countryCode: countryCode,
									vatNo: v.vatNo
								}
							});

							if (!response.valid) {
								Ext.MessageBox.alert(t("Invalid"), t("The VAT number is not validated by the VIES service for country {country}").replace("{country}", countryCode));
							} else {
								Ext.MessageBox.alert(t("Valid"), t("This VAT number is registered to {name} at {address}")
									.replace("{name}", response.name)
									.replace("{address}", response.address));
							}
						} catch(e) {
							GO.errorDialog.show(e.message);
						}
						finally {
							this.getEl().unmask();
						}
					},
					scope: this
				})
			)
		})
	});
});
