<?php
namespace go\modules\community\bookmarks;
							
use go\core;
use go\core\model;
use go\core\model\Acl;
use go\core\model\Group;
use go\core\model\Module as GoModule;
use go\modules\community\bookmarks\model\Bookmark;
use go\modules\community\bookmarks\model\Category;

/**						
 * @copyright (c) 2019, Intermesh BV http://www.intermesh.nl
 * @author Merijn Schering <mschering@intermesh.nl>
 * @license http://www.gnu.org/licenses/agpl-3.0.html AGPLv3
 */
class Module extends core\Module {
	/**
	 * The development status of this module
	 * @return string
	 */
	public function getStatus() : string{
		return self::STATUS_STABLE;
	}

	public function getAuthor(): string
	{
		return "Intermesh BV <info@intermesh.nl>";
	}

	public function autoInstall(): bool
	{
		return true;
	}


	protected function beforeInstall(\go\core\model\Module $model): bool
	{
		// Share module with Internal group
		$model->permissions[Group::ID_INTERNAL] = (new \go\core\model\Permission($model))
			->setRights(['mayRead' => true]);

		return parent::beforeInstall($model); // TODO: Change the autogenerated stub
	}

	protected function afterInstall(model\Module $model): bool
	{

		$category = new Category();
		$category->name = go()->t('General', 'community', 'bookmarks');
		$category->setAcl([Group::ID_INTERNAL => Acl::LEVEL_READ]);
		$category->save();


		$bookmark = new Bookmark();
		$bookmark->categoryId =$category->id;
		$bookmark->name='Group-Office';
		$bookmark->content='https://www.group-office.com';
		$bookmark->loadMetaData();
		$bookmark->save();


		$bookmark = new Bookmark();
		$bookmark->categoryId =$category->id;
		$bookmark->name='Intermesh';
		$bookmark->content='https://www.intermesh.nl';
		$bookmark->loadMetaData();
		$bookmark->save();

		return true;

	}


}