<?php
namespace go\modules\community\comments;

use GO\Base\Db\ActiveRecord;
use go\core;
use go\core\cron\GarbageCollection;
use go\core\jmap\Entity;
use Faker;
use go\core\model\Group;
use go\core\model\Module as GoModule;
use go\modules\community\comments\model\Comment;
use go\modules\humblebuildings\cvgenerator\model\Generator;

class Module extends core\Module
{

	/**
	 * The development status of this module
	 * @return string
	 */
	public function getStatus() : string{
		return self::STATUS_STABLE;
	}

	public function getAuthor(): string
	{
		return "Intermesh BV";
	}

	public function autoInstall(): bool
	{
		return true;
	}

	public function defineListeners()
	{
		GarbageCollection::on(GarbageCollection::EVENT_RUN, static::class, 'garbageCollection');

	}


	protected function beforeInstall(\go\core\model\Module $model): bool
	{
		// Share module with Internal group
		$model->permissions[Group::ID_INTERNAL] = (new \go\core\model\Permission($model))
			->setRights(['mayRead' => true]);

		return parent::beforeInstall($model); // TODO: Change the autogenerated stub
	}

	
	public static function garbageCollection() {
		$types = core\orm\EntityType::findAll();

		go()->debug("Cleaning up comments");
		foreach($types as $type) {
			if($type->getName() == "Comment" || $type->getName() == "Link" || $type->getName() == "Search" ||
				(!is_a($type->getClassName(), Entity::class, true) && !is_a($type->getClassName(), ActiveRecord::class, true))
			) {
				continue;
			}

			$cls = $type->getClassName();

			if(is_a($cls,  ActiveRecord::class, true)) {
				$tableName = $cls::model()->tableName();
			} else{
				$tableName = array_values($cls::getMapping()->getTables())[0]->getName();
			}

			if(!go()->getDatabase()->getTable($tableName)->getColumn('id')) {
				continue;
			}
			$query = (new core\orm\Query())->select('sub.id')->from($tableName, 'sub');

			$stmt = go()->getDbConnection()->delete('comments_comment', (new core\orm\Query())
				->where('entityTypeId', '=', $type->getId())
				->andWhere('entityId', 'NOT IN', $query)
			);
//			echo $stmt ." \n\n";

			$stmt->execute();

			go()->debug("Deleted ". $stmt->rowCount() . " comments for $cls");
		}
	}

	private static $demoTexts;

	private static function demoText(Faker\Generator $faker) : string{
		if(!isset(static::$demoTexts )) {
			static::$demoTexts = [];
			for($i = 0; $i < 20; $i++) {
				static::$demoTexts [] = nl2br($faker->realtext);
			}
		}

		return static::$demoTexts [$faker->numberBetween(0, count(static::$demoTexts) - 1 )];

	}

	private static $demoUsers;

	/**
	 * @return User[]
	 */
	private static function demoUsers(): array
	{
		return self::$demoUsers ?? (self::$demoUsers = core\model\User::find(['id'])->limit(10)->all());
	}

	/**
	 * Create some demo comments
	 *
	 * @param Faker\Generator $faker
	 * @param Entity|ActiveRecord $entity
	 * @throws \Exception
	 */
	public static function demoComments(Faker\Generator $faker, $entity) {

//		gc_collect_cycles();

		$faker = Faker\Factory::create();

		$users = self::demoUsers();
		$userCount = count($users) - 1;

		$commentCount = $faker->numberBetween(1, 5);

		$date = $faker->dateTimeBetween("-2 years", "-" . $commentCount . "days");

		for($i = 0; $i < $commentCount; $i++) {
			try {
				$user = $users[$faker->numberBetween(0, $userCount)];

				$comment = new Comment();
				$comment->setEntity($entity);
				$comment->text = self::demoText($faker);
				$comment->createdBy = $user->id;
				$comment->date = $date;

				$date = $date->add(new \DateInterval("P1D"));

				if (!$comment->save()) {
					throw new core\orm\exception\SaveException($comment);
				}
			}catch (\Exception $e) {
				core\ErrorHandler::logException($e);
			}
		}
	}
}
