GO.tickets.SelectContact = Ext.extend(go.form.ComboBox, {
	sep: ',',
	fieldLabel: t("Contact", "tickets"),
	flex: 1,
	valueField: 'name',
	displayField: 'name',
	name: "contact_name",

	initComponent: function () {

		this.store = new go.data.Store({
			method: "Search/email",
			fields: ['entityId', 'entity', 'email', 'name', 'photoBlobId']
		});

		this.tpl = new Ext.XTemplate(
			'<tpl for=".">',
			'<div class="x-combo-list-item"><div class="user">\
					 <tpl if="!photoBlobId"><div class="avatar"></div></tpl>\\n\
					 <tpl if="photoBlobId"><div class="avatar" style="background-image:url({[go.Jmap.thumbUrl(values.photoBlobId, {w: 40, h: 40, zc: 1}) ]})"></div></tpl>\
					 <div class="wrap">\
						 <div>{email}</div><small>{name}</small>\
					 </div>\
				 </div></div>',
			'</tpl>'
		);

		GO.tickets.SelectContact.superclass.initComponent.call(this);

	}
});