/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Field, FieldEventMap, FieldValue } from "./Field.js";
import { Config } from "../Observable";
/**
 * @inheritDoc
 */
type ArrayFieldConfig<Type extends FieldValue = Record<string, any>> = Config<ArrayField<Type>, FieldEventMap<ArrayField<Type>>, "buildField">;
type FieldBuilder<Type extends FieldValue = Record<string, any>> = (value?: Type) => Field;
export interface ArrayField<Type extends FieldValue = Record<string, any>> extends Field {
    get value(): Type[];
    set value(value: Type[]);
}
/**
 * Field to return an array with objects
 *
 * @see Form
 */
export declare class ArrayField<Type extends FieldValue = Record<string, any>> extends Field {
    buildField: FieldBuilder<Type>;
    /**
     *
     * @param buildField Function that returns a new form field for an array item
     */
    constructor(buildField: FieldBuilder<Type>);
    protected renderControl(): void;
    private enableChangeEvent;
    protected internalSetValue(v?: any): void;
    protected internalGetValue(): Type[];
    /**
     * Add value to the values array. Also fires change event
     *
     * @param value
     */
    addValue(value: Type): Field;
    private internalAddValue;
    reset(): void;
    isEmpty(): boolean;
}
/**
 * Shorthand function to create {@see ArrayField}
 *
 * @see https://github.com/Intermesh/goui-docs/blob/main/script/form/ArrayFieldPage.ts
 *
 * @param config
 * @param items
 */
export declare const arrayfield: <Type extends FieldValue = Record<string, any>>(config: ArrayFieldConfig<Type>, ...items: Field[]) => ArrayField<Type>;
export {};
//# sourceMappingURL=ArrayField.d.ts.map