/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Michael de Hart <mdhart@intermesh.nl>
 */
import { Component, ComponentEventMap } from "../Component.js";
import { DateTime } from "../../util/DateTime.js";
import { Config, Listener, ObservableListenerOpts } from "../Observable.js";
export interface DatePickerEventMap<Type> extends ComponentEventMap<Type> {
    'select': (datepicker: Type, date: DateTime | undefined) => false | void;
    'select-range': (datepicker: Type, start: DateTime | undefined, end: DateTime | undefined) => false | void;
}
export interface DatePicker extends Component {
    on<K extends keyof DatePickerEventMap<this>, L extends Listener>(eventName: K, listener: Partial<DatePickerEventMap<this>>[K], options?: ObservableListenerOpts): L;
    un<K extends keyof DatePickerEventMap<this>>(eventName: K, listener: Partial<DatePickerEventMap<this>>[K]): boolean;
    fire<K extends keyof DatePickerEventMap<this>>(eventName: K, ...args: Parameters<DatePickerEventMap<Component>[K]>): boolean;
}
export declare class DatePicker extends Component {
    showWeekNbs: boolean;
    value: DateTime;
    private now;
    enableRangeSelect: boolean;
    protected baseCls: string;
    protected monthEl: HTMLButtonElement;
    protected yearEl: HTMLButtonElement;
    protected years: HTMLElement;
    protected months: HTMLElement;
    protected grid: HTMLElement;
    protected menu: HTMLElement;
    withoutFooter?: boolean;
    minDate?: DateTime;
    maxDate?: DateTime;
    /**
     * Used to determine if a refresh() is needed when new value is set.
     * @private
     */
    private renderedMonth?;
    constructor();
    moveMonth(amount: number): void;
    render(parentEl?: Node, insertBefore?: Node): HTMLElement;
    /**
     * Refresh the view
     */
    refresh(): void;
    private constrainValue;
    private setYearClases;
    private setMonthClasses;
    protected internalRender(): HTMLElement;
    setValue(start: DateTime, end?: DateTime): void;
    private markSelected;
    private setupDraggability;
}
export declare const datepicker: (config?: Config<DatePicker, DatePickerEventMap<DatePicker>>) => DatePicker;
//# sourceMappingURL=DatePicker.d.ts.map