import { AbstractDataSource, BaseEntity, Changes, CommitResponse, DefaultEntity, EntityID, GetResponse, QueryParams, QueryResponse, SetRequest } from "./AbstractDataSource";
/**
 * @category Data
 */
export declare class RestDataSource<EntityType extends BaseEntity = DefaultEntity> extends AbstractDataSource<EntityType> {
    readonly uri: string;
    /**
     * Constructor
     *
     * @param uri The base URI of the REST API. for example https://groupoffice.com/api
     * @param id The Data source ID. Will be appended to the base uri above. for Example
     *  if the ID is "users" the uri will be: "https://groupoffice.com/api/users"
     */
    constructor(uri: string, id?: string);
    read(id: number | number[], path?: string, options?: RequestInit): Promise<any>;
    doRequest(path?: string, options?: RequestInit): Promise<any>;
    private request;
    protected internalCommit(params: SetRequest<EntityType>): Promise<CommitResponse<EntityType>>;
    protected internalGet(ids: EntityID[]): Promise<GetResponse<EntityType>>;
    protected internalQuery(params: QueryParams): Promise<QueryResponse>;
    /**
     * No sync implemented for REST. States are ignored and data must always be refreshed.
     * @param state
     * @protected
     */
    protected internalRemoteChanges(state: string | undefined): Promise<Changes>;
}
//# sourceMappingURL=RestDataSource.d.ts.map