/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Button, ButtonEventMap } from "./Button.js";
import { Component } from "./Component.js";
import { Config, Listener, ObservableListenerOpts } from "./Observable.js";
/**
 * @inheritDoc
 */
export interface SearchButtonEventMap<Type> extends ButtonEventMap<Type> {
    input: (searchBtn: Type, text: string) => void;
    reset: (searchBtn: Type) => void;
}
export interface SearchButton extends Button {
    on<K extends keyof SearchButtonEventMap<this>, L extends Listener>(eventName: K, listener: Partial<SearchButtonEventMap<this>>[K], options?: ObservableListenerOpts): L;
    un<K extends keyof SearchButtonEventMap<this>>(eventName: K, listener: Partial<SearchButtonEventMap<this>>[K]): boolean;
    fire<K extends keyof SearchButtonEventMap<this>>(eventName: K, ...args: Parameters<SearchButtonEventMap<Component>[K]>): boolean;
}
export declare class SearchButton extends Button {
    private searchField;
    private searchTBar?;
    private mainTbar?;
    private buffer;
    constructor();
    handler: (button: Button, ev?: MouseEvent) => void;
    reset(): void;
    close(): void;
    private onInput;
    private getSearchTBar;
}
/**
 * Shorthand function to create {@see SearchButton}
 *
 * @example
 * ```
 * searchbtn({
 * 	listeners: {
 * 		input:(searchBtn, text) => {
 *
 * 			const filtered = records.filter((r) => {
 * 				return !text || r.description.toLowerCase().indexOf(text.toLowerCase()) === 0;
 * 			});
 *
 * 			//simple local filter on the store
 * 			table.store.loadData(filtered, false)
 * 		}
 * 	}
 * })
 * ```
 *
 * @param config
 * @param items
 */
export declare const searchbtn: (config?: Config<SearchButton, SearchButtonEventMap<SearchButton>>) => SearchButton;
//# sourceMappingURL=SearchButton.d.ts.map