/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { createComponent } from "../Component.js";
import { E } from "../../util/Element.js";
import { InputField } from "./InputField";
/**
 * Checkbox field
 *
 * @see Form
 */
export class CheckboxField extends InputField {
    /**
     *
     * @param type Render the checkbox as a checkbox, switch or toggle button
     */
    constructor(type = 'box') {
        super();
        this.baseCls = 'goui-form-field check';
        this.el.cls(type, true);
        this.type = "checkbox";
    }
    applyTitle() {
        if (this.title) {
            this.input.title = this.title;
        }
    }
    focus(o) {
        if (!this.input) {
            super.focus(o);
        }
        else {
            this.input.focus(o);
            this.fire("focus", this, o);
        }
    }
    createLabel() {
        const lbl = E('span').cls('box-label');
        lbl.innerHTML = this.label;
        if (this._cls) {
            lbl.cls("+" + this._cls);
        }
        this.control.append(lbl);
        this._labelEl = lbl;
    }
    createControl() {
        this._input = this.createInput();
        this._input.on("click", () => this.validate());
        const control = E('div', this._input);
        return control;
    }
    set color(v) {
        this.input.style.backgroundColor = v || '';
    }
    get color() {
        return this.input.style.backgroundColor;
    }
    internalSetValue(v) {
        if (this.input) {
            this.input.checked = v;
        }
    }
    internalGetValue() {
        if (!this.input) {
            //always return bool
            return !!this._value;
        }
        else {
            return this.input.checked;
        }
    }
}
/**
 * Shorthand function to create {@see CheckboxField}
 *
 * @param config
 */
export const checkbox = (config) => {
    const type = (config === null || config === void 0 ? void 0 : config.type) || 'box';
    config === null || config === void 0 ? true : delete config.type;
    return createComponent(new CheckboxField(type), config);
};
//# sourceMappingURL=CheckboxField.js.map