/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Component, createComponent } from "../Component.js";
/**
 * Field set component
 *
 * @see Form
 */
export class Fieldset extends Component {
    constructor() {
        super("fieldset");
        this.baseCls = "goui-fieldset";
        this.cls = "flow";
    }
    internalRender() {
        const el = super.internalRender();
        if (this.legend) {
            const l = document.createElement("h3"); // no legend tag as it's behaving wierd
            l.innerHTML = this.legend;
            l.classList.add("legend");
            el.insertBefore(l, el.firstChild);
        }
        return el;
    }
}
/**
 * Shorthand function to create fieldset
 *
 * @param config
 * @param items
 */
export const fieldset = (config, ...items) => createComponent(new Fieldset(), config, items);
//# sourceMappingURL=Fieldset.js.map