/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Field } from "./Field.js";
import { createComponent } from "../Component.js";
/**
 * TextField component
 *
 * @see Form
 */
export class HiddenField extends Field {
    constructor() {
        super();
        this.baseCls = '';
        this.hidden = true;
    }
}
/**
 * Shorthand function to create {@see HiddenField}
 *
 * @param config
 */
export const hiddenfield = (config) => createComponent(new HiddenField(), config);
//# sourceMappingURL=HiddenField.js.map